import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import onig4j.OnigRegex;
import onig4j.OnigRegion;
import onig4j.OnigSyntaxType;
import org.junit.Test;

/**
 *
 * @author calico
 */
public class Benchmark {
    private static final String BENCHMARK_HTML
            = System.getProperty("user.dir") + "/test/benchmark.html";
    private static final String REGEX_PATTERN
            = ".*\"(/tvpi.epg\\?pg=tv_record.html&program=p([0-9]*)(&area=([0-9]*))?)\".*";
    private static final NumberFormat formatter = new DecimalFormat("#,##0");
    
    static {
        System.out.printf("JVM: %s %s %s (%s)\n", System.getProperty("java.version"), System.getProperty("java.vm.name"), System.getProperty("java.vm.version"), System.getProperty("java.vm.vendor"));
        System.out.printf("OS : %s ver %s (%s)\n", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
        System.out.println("Regex Pattern     : " + REGEX_PATTERN);
        System.out.println("Target File URL   : http://tv.www.infoseek.co.jp/");
        System.out.println("Target File Size  : " + formatter.format(new File(BENCHMARK_HTML).length()) + " bytes");
    }
    
    private static BufferedReader openBenchmarkHtml() throws UnsupportedEncodingException, FileNotFoundException {
        return new BufferedReader(new InputStreamReader(new FileInputStream(BENCHMARK_HTML), "x-euc-jp"));
    }
    
    @Test
    public void javaRegex() throws IOException {
        final BufferedReader reader = openBenchmarkHtml();
//        final List<String> urls = new ArrayList<String>();
        int hit = 0;
        final long st = System.nanoTime();
        
        final Pattern regex = Pattern.compile(REGEX_PATTERN);
        String line = null;
        while ((line = reader.readLine()) != null) {
            final Matcher matcher = regex.matcher(line);
            if (matcher.matches()) {
                ++hit;
                final String url = matcher.group(1);
//                urls.add(url);
//                System.out.println(url);
            }
        }
        final long et = System.nanoTime();
        
        System.out.println("Hit Count   (Java): " + formatter.format(hit));
        System.out.println("Process Time(Java): " + formatter.format(et - st) + " nanoseconds");
        
        reader.close();
    }

    @Test
    public void onigRegex() throws UnsupportedEncodingException, FileNotFoundException, IOException {
        final BufferedReader reader = openBenchmarkHtml();
//        final List<String> urls = new ArrayList<String>();
        int hit = 0;
        final long st = System.nanoTime();
        
        final OnigRegex regex = new OnigRegex(REGEX_PATTERN, OnigSyntaxType.ONIG_SYNTAX_JAVA);
        final OnigRegion region = new OnigRegion();
        String line = null;
        while ((line = reader.readLine()) != null) {
            final int ret = regex.search(line, region);
            if (ret >= 0) {
                ++hit;
                final String url = line.substring(region.begin(1), region.end(1));
//                urls.add(url);
//                System.out.println(url);
            }
        }
        final long et = System.nanoTime();
        
        System.out.println("Hit Count   (Onig): " + formatter.format(hit));
        System.out.println("Process Time(Onig): " + formatter.format(et - st) + " nanoseconds");
        
        reader.close();
    }
    
    public static void main(String[] args) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        Benchmark bench = new Benchmark();
        bench.javaRegex();
        bench.onigRegex();
    }

}