package onig4j;

import java.util.Collection;
import java.util.EnumSet;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author calico
 */
public class OnigOptionTypeTest {

    @Test
    public void valuesOf() {
        EnumSet<OnigOptionType> options = OnigOptionType.valuesOf(0);
        assertEquals(1, options.size());
        assertSame(OnigOptionType.ONIG_OPTION_NONE, options.toArray()[0]);
        
        options = OnigOptionType.valuesOf(1);
        assertEquals(1, options.size());
        assertSame(OnigOptionType.ONIG_OPTION_IGNORECASE, options.toArray()[0]);
        
        options = OnigOptionType.valuesOf(1 << 1);
        assertEquals(1, options.size());
        assertSame(OnigOptionType.ONIG_OPTION_EXTEND, options.toArray()[0]);

        options = OnigOptionType.valuesOf(1 | 1 << 1);
        assertEquals(2, options.size());
        assertSame(OnigOptionType.ONIG_OPTION_IGNORECASE, options.toArray()[0]);
        assertSame(OnigOptionType.ONIG_OPTION_EXTEND, options.toArray()[1]);
    }
    
    @Test
    public void values() {
        assertEquals(0, OnigOptionType.values((OnigOptionType) null));
        assertEquals(0, OnigOptionType.values((Collection<OnigOptionType>) null));
        
        assertEquals(0, OnigOptionType.values(OnigOptionType.ONIG_OPTION_NONE));
        
        assertEquals(1 << 7, OnigOptionType.values(OnigOptionType.ONIG_OPTION_DONT_CAPTURE_GROUP));
                
        assertEquals(
                1 << 7 | 1 << 11,
                OnigOptionType.values(EnumSet.of(OnigOptionType.ONIG_OPTION_DONT_CAPTURE_GROUP, OnigOptionType.ONIG_OPTION_POSIX_REGION))
            );
                
        assertEquals(
                1 << 7 | 1 << 11,
                OnigOptionType.values(OnigOptionType.ONIG_OPTION_DONT_CAPTURE_GROUP, OnigOptionType.ONIG_OPTION_POSIX_REGION)
            );
    }
}