/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.compiler;

/**
 * @author Kota Mizushima
 * Date: 2005/04/08
 */
public class CompilationConfiguration implements Cloneable{
  private final String[] sourcepath;
  private final String[] classpath;
  private final String encoding;
  private final String outputDirectory;
  private final int maxErrorReports;

  public CompilationConfiguration(
    String[] sourcepath, String[] classpath, 
    String encoding, String outputDirectory, int maxErrorReports){
    this.sourcepath = sourcepath;
    this.classpath = classpath;
    this.encoding = encoding;
    this.outputDirectory = outputDirectory;
    this.maxErrorReports = maxErrorReports;
  }
  
  public Object clone(){
    return new CompilationConfiguration(
       (String[])sourcepath.clone(),
       (String[])classpath.clone(),
       encoding,
       outputDirectory,
       maxErrorReports
    );
  }
  
  public String[] getSourcepath(){
    return (String[])sourcepath.clone();
  }
  
  public String[] getClasspath(){
    return (String[])classpath.clone();
  }
  
  public String getEncoding(){
    return encoding;
  }
  
  public String getOutputDirectory(){
    return outputDirectory;
  }
  
  public int getMaxErrorReports(){
    return maxErrorReports;
  } 
}
