/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.compiler.environment;

import java.util.*;
import java.util.List;
import java.util.Map;

import org.apache.bcel.classfile.JavaClass;
import org.onion_lang.onion.compiler.utility.Strings;
import org.onion_lang.onion.lang.kernel.ClassNode;
import org.onion_lang.onion.lang.kernel.type.*;

/**
 * @author Kota Mizushima
 * Date: 2005/06/22
 */
public class ClassTable {
  private List sourceClasses;
  private Map sourceClassMap;
  private Map classFileMap;
  private Map arrayMap;
  private ClassFileTable table;
  
  public ClassTable(String classPath) {
    sourceClasses = new ArrayList();
    sourceClassMap = new HashMap();
    classFileMap = new HashMap();
    arrayMap = new HashMap();
    table = new ClassFileTable(classPath);
  }
  
  public void addSourceClass(ClassNode node){
    sourceClasses.add(node);
    sourceClassMap.put(node.getName(), node);
  }
  
  public ClassNode[] getSourceClasses(){
    return (ClassNode[])sourceClasses.toArray(new ClassNode[0]);
  }
  
  public ArraySymbol loadArray(TypeSymbol component, int dimension){
    String arrayName = Strings.repeat("[", dimension) + component.getName();
    ArraySymbol array = (ArraySymbol) arrayMap.get(arrayName);
    if(array != null) return array;
    array = new ArraySymbol(component, dimension, this);
    arrayMap.put(arrayName, array);
    return array;
  }
  
  public ClassSymbol load(String className){
    ClassSymbol symbol = lookup(className);
    if(symbol == null){
      JavaClass javaClass = table.load(className);
      if(javaClass != null){
        symbol = new ClassFileSymbol(javaClass, this);
        addClassFileSymbol(symbol);
      }
    }
    return symbol;
  }
  
  public ClassSymbol rootClass(){
    return load("java.lang.Object");
  }
  
  public ClassSymbol lookup(String className){
    ClassSymbol symbol = (ClassSymbol) sourceClassMap.get(className);
    return (symbol != null) ? symbol : (ClassSymbol) classFileMap.get(className);
  }
  
  private void addClassFileSymbol(ClassSymbol symbol){
    classFileMap.put(symbol.getName(), symbol);
  }
  
  private void addSuperTypeClosure(ClassSymbol symbol){
    Set closure = new HashSet();
    List queue = new LinkedList();
    queue.add(symbol);
    while(!queue.isEmpty()){
      ClassSymbol object = (ClassSymbol) queue.remove(0);
      if(closure.contains(object) || lookup(object.getName()) != null){
        return;
      }else{
        closure.add(object);
      }
      ClassSymbol superClass = object.getSuperClass();
      if(superClass != null) queue.add(superClass);
      ClassSymbol[] interfaces = object.getInterfaces();
      for(int i = 0; i < interfaces.length; i++){
        queue.add(interfaces[i]);
      }
    }
    for(Iterator iterator = closure.iterator(); iterator.hasNext();){
      addClassFileSymbol((ClassSymbol)iterator.next());
    }
  }
}