/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.compiler.environment;

import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

/**
 * @author Kota Mizushima
 * Date: 2005/06/28
 */
public class ClosureLocalBinding extends LocalBinding {
  private int frame;
  
  public ClosureLocalBinding(int frame, int index, TypeSymbol type) {
    super(index, type);
    this.frame = frame;
  }

  public void setFrame(int frameIndex) {
    this.frame = frameIndex;
  }

  public int getFrame() {
    return frame;
  }
  
  public boolean equals(Object object){
    if(!(object instanceof ClosureLocalBinding)) return false;
    ClosureLocalBinding bind = (ClosureLocalBinding) object;
    if(frame != bind.frame) return false;
    if(getIndex() != bind.getIndex()) return false;
    if(getType() != bind.getType()) return false;
    return true;
  }
}
