/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.compiler.environment;

import java.util.*;
import java.util.TreeSet;

import org.onion_lang.onion.lang.kernel.ExpressionNode;
import org.onion_lang.onion.lang.kernel.type.*;


/**
 * @author Kota Mizushima
 * Date: 2005/06/30
 */
public class ConstructorFinder {
  private static Comparator sorter = new Comparator(){
    public int compare(Object constructor1, Object constructor2) {
      ConstructorSymbol c1 = (ConstructorSymbol)constructor1;
      ConstructorSymbol c2 = (ConstructorSymbol)constructor2;
      TypeSymbol[] arg1 = c1.getArguments();
      TypeSymbol[] arg2 = c2.getArguments();
      int length = arg1.length;
      if(isAllSuperType(arg2, arg1)) return -1;
      if(isAllSuperType(arg1, arg2)) return 1;
      return 0;
    }
  };
  
  private static Comparator comparator = new Comparator(){
    public int compare(Object constructor1, Object constructor2) {
      ConstructorSymbol c1 = (ConstructorSymbol)constructor1;
      ConstructorSymbol c2 = (ConstructorSymbol)constructor2;
      TypeSymbol[] arg1 = c1.getArguments();
      TypeSymbol[] arg2 = c2.getArguments();
      int length = arg1.length;
      for(int i = 0; i < length; i++){
        if(arg1[i] != arg2[i]) return -1;
      }
      return 0;
    }
  };
  
  private ParameterMatcher matcher;
  
  public ConstructorFinder() {
    this.matcher = new StandardParameterMatcher();
  }
    
  public ConstructorSymbol[] lookup(
    ClassSymbol target, ExpressionNode[] arguments){
    Set constructors = new TreeSet(comparator);
    lookup(constructors, target, arguments);
    List selected = new ArrayList();
    selected.addAll(constructors);
    Collections.sort(selected, sorter);
    return 
    	(ConstructorSymbol[]) selected.toArray(
    	  new ConstructorSymbol[0]);
  }
  
  public int compareSpecific(
    ConstructorSymbol constructor1, ConstructorSymbol constructor2){
    return sorter.compare(constructor1, constructor2);
  }
  
  public boolean isAmbiguous(ConstructorSymbol[] constructors){
    return 
    	constructors.length > 1 && 
    	compareSpecific(constructors[0], constructors[1]) >= 0;
  }
  
  private void lookup(Set constructors, ClassSymbol target, ExpressionNode[] arguments){
    if(target == null) return;
    ConstructorSymbol[] cs = target.getConstructors();
    for(int i = 0; i < cs.length; i++){
      ConstructorSymbol c = cs[i];
      if(matcher.matches(c.getArguments(), arguments)){
        constructors.add(c);
      }
    }
  }
  
  private static boolean isAllSuperType(
    TypeSymbol[] arg1, TypeSymbol[] arg2){
    for(int i = 0; i < arg1.length; i++){
      if(!TypeRules.isSuperType(arg1[i], arg2[i])) return false;
    }
    return true;
  }  
}
