/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.compiler.environment;

/**
 * @author Kota Mizushima
 * Date: 2005/04/15
 */
public class ImportItem {
  private String simpleName;
  private String fullyQualifiedName;
  private boolean isWildcard;

  public ImportItem(
    String simpleName, String fullyQualifiedName){
    this.simpleName = simpleName;
    this.fullyQualifiedName = fullyQualifiedName;
    this.isWildcard = simpleName.equals("*");
  }
  
  /**
   * returns simple name.
   * @return
   */
  public String getSimpleName(){
    return simpleName;
  }
  
  /**
   * returns fully qualified name.
   * @return
   */
  public String getFullyQualifiedName(){
    return fullyQualifiedName;
  }
  
  /**
   * returns whether this is wildcard import or not.
   * @return
   */
  public boolean isWildcard(){
    return isWildcard;
  }
  
  /**
   * generate fully qualified name from simple name.
   * @param simpleName
   * @return fqcn.  if simpleName is not matched, then return null.
   */
  public String match(String simpleName){
    if(isWildcard){
      return fullyQualifiedName.replace("*", simpleName);
    }else if(this.simpleName.equals(simpleName)){
      return fullyQualifiedName;
    }else{
      return null;
    }
  }

}
