/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.compiler.environment;

import java.util.*;
import java.util.TreeSet;

import org.onion_lang.onion.lang.kernel.ExpressionNode;
import org.onion_lang.onion.lang.kernel.type.*;


/**
 * @author Kota Mizushima
 * Date: 2005/06/30
 */
public class MethodFinder {
  private static Comparator sorter = new Comparator(){
    public int compare(Object method1, Object method2) {
      MethodSymbol m1 = (MethodSymbol)method1;
      MethodSymbol m2 = (MethodSymbol)method2;
      TypeSymbol[] arg1 = m1.getArguments();
      TypeSymbol[] arg2 = m2.getArguments();
      int length = arg1.length;
      if(isAllSuperType(arg2, arg1)) return -1;
      if(isAllSuperType(arg1, arg2)) return 1;
      return 0;
    }
  };
    
  private ParameterMatcher matcher;
  
  public MethodFinder() {
    this.matcher = new StandardParameterMatcher();
  }
    
  public MethodSymbol[] lookup(
    ObjectSymbol target, String name, ExpressionNode[] arguments){
    Set methods = new TreeSet(new MethodSymbolComparator());
    lookup(methods, target, name, arguments);
    List selectedMethods = new ArrayList();
    selectedMethods.addAll(methods);
    Collections.sort(selectedMethods, sorter);
    return (MethodSymbol[]) selectedMethods.toArray(new MethodSymbol[0]);
  }
  
  public int compareSpecific(MethodSymbol method1, MethodSymbol method2){
    return sorter.compare(method1, method2);
  }
  
  public boolean isAmbiguous(MethodSymbol[] methods){
    return methods.length > 1 && compareSpecific(methods[0], methods[1]) >= 0;
  }
  
  private void lookup(
    Set methods, ObjectSymbol target, String name, ExpressionNode[] arguments){
    if(target == null) return;
    MethodSymbol[] ms = target.getMethods();
    for(int i = 0; i < ms.length; i++){
      MethodSymbol m = ms[i];
      if(m.getName().equals(name) && matcher.matches(m.getArguments(), arguments)){
        methods.add(m);
      }
    }
    ClassSymbol superClass = target.getSuperClass();
    lookup(methods, superClass, name, arguments);
    ClassSymbol[] interfaces = target.getInterfaces();
    for(int i = 0; i < interfaces.length; i++){
      lookup(methods, interfaces[i], name, arguments);
    }
  }
  
  private static boolean isAllSuperType(
    TypeSymbol[] arg1, TypeSymbol[] arg2){
    for(int i = 0; i < arg1.length; i++){
      if(!TypeRules.isSuperType(arg1[i], arg2[i])) return false;
    }
    return true;
  }  
}
