/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.compiler.environment;

import org.onion_lang.onion.lang.kernel.type.*;
import org.onion_lang.onion.lang.syntax.TypeComponent;
import org.onion_lang.onion.lang.syntax.TypeSpecifier;

/**
 * @author Kota Mizushima
 * Date: 2005/06/13
 */
public class NameResolution {
  private ImportList imports;
  private ClassTable table;

  public NameResolution(ImportList imports, ClassTable table) {
    this.imports = imports;
    this.table = table;
  }
    
  public TypeSymbol resolve(TypeSpecifier specifier){
    TypeSymbol componentType = 
      resolveSub(specifier.getComponent());
    if(specifier.getDimension() > 0){
      return
      	table.loadArray(componentType, specifier.getDimension());
    }else{
      return componentType;
    }
  }
    
  private TypeSymbol resolveSub(TypeComponent component){
    String name = component.getName();
    if(component.getKind() == TypeComponent.BASIC){
      if(name.equals("char")) return BasicSymbol.CHAR;
      if(name.equals("byte")) return BasicSymbol.BYTE;
      if(name.equals("short")) return BasicSymbol.SHORT;
      if(name.equals("int")) return BasicSymbol.INT;
      if(name.equals("long")) return BasicSymbol.LONG;
      if(name.equals("float")) return BasicSymbol.FLOAT;
      if(name.equals("double")) return BasicSymbol.DOUBLE;
      if(name.equals("boolean")) return BasicSymbol.BOOLEAN;
      return BasicSymbol.VOID;
    }else if(component.getKind() == TypeComponent.NOT_QUALIFIED){
      return forSName(name);
    }else{
      return forQName(name);
    }
  }
  
  private ClassSymbol forQName(String qualifiedName){
    return table.load(qualifiedName);
  }
  
  private ClassSymbol forSName(String simpleName){
    for(int i = 0; i < imports.size(); i++){
      String qualifiedName = imports.get(i).match(simpleName);
      if(qualifiedName != null){
        ClassSymbol resolvedSymbol = forQName(qualifiedName);
        if(resolvedSymbol != null) return resolvedSymbol;
      }
    }
    return null;
  }
}
