/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.compiler.environment;

import java.util.HashMap;
import java.util.Map;

import org.apache.bcel.generic.*;
import org.apache.bcel.generic.BasicType;
import org.onion_lang.onion.lang.kernel.type.*;

/**
 * @author Kota Mizushima
 * Date: 2005/06/28
 */
public class OnionTypeBridge {
  private static Map basicTypeTable = new HashMap(){{
    put(BasicType.BYTE, BasicSymbol.BYTE);
    put(BasicType.SHORT, BasicSymbol.SHORT);
    put(BasicType.CHAR, BasicSymbol.CHAR);
    put(BasicType.INT, BasicSymbol.INT);
    put(BasicType.LONG, BasicSymbol.LONG);
    put(BasicType.FLOAT, BasicSymbol.FLOAT);
    put(BasicType.DOUBLE, BasicSymbol.DOUBLE);
    put(BasicType.BOOLEAN, BasicSymbol.BOOLEAN);
    put(BasicType.VOID, BasicSymbol.VOID);
  }};
  
  private ClassTable table;
  
  public OnionTypeBridge(ClassTable table) {
    this.table = table;
  }
  
  public TypeSymbol toOnionType(Type type){
    TypeSymbol returnType = (TypeSymbol) basicTypeTable.get(type);
    if(returnType != null) return returnType;
    if(type instanceof ObjectType){
      ObjectType objType = (ObjectType)type;
      ClassSymbol symbol = table.load(objType.getClassName());
      if(symbol != null){
        return symbol;
      }else{
        return null;
      }
    }
    if(type instanceof ArrayType){
      ArrayType arrType = (ArrayType)type;
      TypeSymbol component = toOnionType(arrType.getBasicType());
      if(component != null){        
        return table.loadArray(
          component, arrType.getDimensions());
      }
    }
    return null;
  }
}
