/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.kernel;

import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

/**
 * @author Kota Mizushima
 * Date: 2005/06/21
 */
public class ArrayAssignmentNode extends ExpressionNode {
  private ExpressionNode target;
  private ExpressionNode index;
  private ExpressionNode value;

  public ArrayAssignmentNode(
    ExpressionNode target, ExpressionNode index, ExpressionNode value) {
    this.target = target;
    this.index = index;
    this.value = value;
  }

  public ExpressionNode getIndex() {
    return index;
  }
  
  public void setIndex(ExpressionNode index) {
    this.index = index;
  }
  
  public ExpressionNode getTarget() {
    return target;
  }
  
  public void setTarget(ExpressionNode target) {
    this.target = target;
  }
  
  public ExpressionNode getValue() {
    return value;
  }
  
  public void setValue(ExpressionNode value) {
    this.value = value;
  }
  
  public TypeSymbol type(){
    return value.type();
  }
}