/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.kernel;

import org.onion_lang.onion.compiler.environment.LocalFrame;
import org.onion_lang.onion.lang.kernel.type.*;

/**
 * @author Kota Mizushima
 * Date: 2005/04/17
 */
public class ClosureNode extends ExpressionNode {
  private ClassSymbol type;
  private MethodSymbol method;
  private StatementNode block;
  private LocalFrame frame;
  
  public ClosureNode(ClassSymbol type, MethodSymbol method, StatementNode block){
    this.type =  type;
    this.method = method;
    this.block = block;
  }
  
  public int getModifier() {
    return method.getModifier();
  }
  
  public ClassSymbol getClassType() {
    return type;
  }
  
  public MethodSymbol getMethod(){
    return method;
  }
  
  public String getName() {
    return method.getName();
  }
  
  public TypeSymbol[] getArguments() {
    return method.getArguments();
  }
  
  public TypeSymbol getReturnType() {
    return method.getReturnType();
  }
  
  public StatementNode getBlock() {
    return block;
  }

  public void setFrame(LocalFrame frame){
    this.frame = frame;
  }
  
  public LocalFrame getFrame(){
    return frame;
  }
  
  public TypeSymbol type() { return type; }
}
