/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.kernel;

import org.onion_lang.onion.lang.kernel.type.BasicSymbol;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

/**
 * @author Kota Mizushima
 * Date: 2005/04/17
 */
public abstract class ExpressionNode implements KernelNode {
  public ExpressionNode() {
  }
  
  public abstract TypeSymbol type();
  
  public boolean isBasicType(){ return type().isBasicType(); }
  
  public boolean isArrayType() { return type().isArrayType(); }
  
  public boolean isClassType() { return type().isClassType(); }
  
  public boolean isNullType() { return type().isNullType(); }
  
  public boolean isReferenceType(){ return type().isReferenceType(); }
  
  public static ExpressionNode defaultValue(TypeSymbol type){
    if(type == BasicSymbol.CHAR) return new CharNode((char)0); 
    if(type == BasicSymbol.BYTE)return new ByteNode((byte)0);
    if(type == BasicSymbol.SHORT) return new ShortNode((short)0); 
    if(type == BasicSymbol.INT) return new IntegerNode(0); 
    if(type == BasicSymbol.LONG) return new LongNode(0); 
    if(type == BasicSymbol.FLOAT) return new FloatNode(0.0f); 
    if(type == BasicSymbol.DOUBLE) return new DoubleNode(0.0);
    if(type == BasicSymbol.BOOLEAN) return new BooleanNode(false);
    if(type.isReferenceType()) return new NullNode();
    return null;
  }
}