/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.kernel;

import org.onion_lang.onion.lang.kernel.type.MethodSymbol;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

/**
 * @author Kota Mizushima
 * Date: 2005/06/22
 */
public class MethodCallNode extends ExpressionNode {
  public final ExpressionNode target;
  public final MethodSymbol method;
  public final ExpressionNode[] parameters;
  
  public MethodCallNode(
    ExpressionNode target, MethodSymbol method, ExpressionNode[] parameters) {
    this.target = target;
    this.method = method;
    this.parameters = parameters;
  }
  
  public TypeSymbol type() { return method.getReturnType(); }
}
