/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.kernel;

import org.onion_lang.onion.lang.kernel.type.ConstructorSymbol;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

/**
 * @author Kota Mizushima
 * Date: 2005/06/22
 */
public class NewNode extends ExpressionNode {
  public final ConstructorSymbol constructor;
  public final ExpressionNode[] parameters;
  
  public NewNode(ConstructorSymbol constructor, ExpressionNode[] parameters){
    this.constructor = constructor;
    this.parameters = parameters;
  }
  
  public TypeSymbol type() { return constructor.getClassType(); }
}
