/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.kernel;

import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

/**
 * @author Kota Mizushima
 * Date: 2005/04/17
 */
public class SuperInitNode implements KernelNode {  
  private TypeSymbol classType;
  private TypeSymbol[] arguments;
  private ExpressionNode[] expressions;

  public SuperInitNode(
    TypeSymbol classType, TypeSymbol[] arguments, ExpressionNode[] expressions){
    this.classType = classType;
    this.arguments = arguments;
    this.expressions = expressions;
  }
  
  public TypeSymbol getClassType() {
    return classType;
  }
  
  public TypeSymbol[] getArguments() {
    return arguments;
  }
  
  public ExpressionNode[] getExpressions() {
    return expressions;
  }
  
}
