/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
/*
 * Created on 2004/12/02
 */
package org.onion_lang.onion.lang.syntax;

import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;

;


/**
 * @author mizu
 */
public interface AbstractSyntaxTreeNode {
  
  /**
   * This method returns the parent node.
   * @return parent node
   */
  AbstractSyntaxTreeNode getParent();
  
  /**
   * This method set the parent node.
   * @param parent parent node
   */
  void setParent(AbstractSyntaxTreeNode parent);

  /**
   * This method accepts the visitor.  The node which override this method
   * need call visitor.visit(this, context);
   * 
   * @param visitor visitor of this node
   * @param context lexical context
   * @return
   */
  Object accept(ASTVisitor visitor, Object context);

  /**
   * This method returns this node's column by 1 origin.
   * @return column
   */
  int getColumn();
  
  /**
   * This method returns this node's row by 1 origin.
   * @return row
   */
  int getRow();
  

  /**
   * This method set this node's column by 1 origin.
   * @param column
   */
  void setColumn(int column);
  
  /**
   * This method set this node's row by 1 origin.
   */
  void setRow(int row);
  
  /**
   * This method set this node's position of source code.
   * @param position the position of this node
   */
  void setSourcePosition(SourcePosition position);

  /**
   * This method returns this node's position of source code.
   * @return the position of this node
   */
  SourcePosition getSourcePosition();
  
}