/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
/*
 * Created on 2004/12/02
 */
package org.onion_lang.onion.lang.syntax;


import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;

;


/**
 * @author Kota Mizushima
 *  
 */
public class ArrayCreation extends Expression {
  
  private final TypeSpecifier type;

  private final Expression[] arguments;

  public ArrayCreation(TypeSpecifier type, Expression[] arguments) {
    this.type = type;
    this.arguments = arguments;
    setChild(type);
    setChildren(arguments);
  }

  public Object accept(ASTVisitor visitor, Object context) {
    return visitor.visit(this, context);
  }
  
  public Expression[] getArguments(){
    return (Expression[])arguments.clone();
  }
  
  public TypeSpecifier getType() {
    return type;
  }
  
}