/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
/*
 * Created on 2004/12/02
 */
package org.onion_lang.onion.lang.syntax;


import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;


/**
 * @author Kota Mizushima
 * 
 */
public class FieldDeclaration extends MemberDeclaration {
  
  private final Expression initializer;
  
  private final TypeSpecifier type;

  public FieldDeclaration(String name, TypeSpecifier type, Expression initializer) {
    super(name);
    this.initializer = initializer;
    this.type = type;
    setChild(initializer);
    setChild(type);
  }

  public Object accept(ASTVisitor visitor, Object context) {
    return visitor.visit(this, context);
  }
  
  public TypeSpecifier getType() {
    return type;
  }

  public Expression getInitializer() {
    return initializer;
  }
}