/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.syntax;


import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;

;

/**
 * @author Kota Mizushima
 *
 */
public class MethodDeclaration extends MemberDeclaration {
  
  private final ArgumentDeclaration[] arguments;
  private final TypeSpecifier returnType;
  private final BlockStatement block;

  public MethodDeclaration(String name, ArgumentDeclaration[] arguments, TypeSpecifier returnType, BlockStatement block) {
    super(name);
    this.block = block;
    this.arguments = arguments;
    this.returnType = returnType;
    setChildren(arguments);
    setChild(block);
  }

  public Object accept(ASTVisitor visitor, Object context) {
    return visitor.visit(this, context);
  }
  
  public ArgumentDeclaration[] getArguments(){
    return (ArgumentDeclaration[])arguments.clone();
  }
  
  public TypeSpecifier getReturnType(){
    return returnType;
  }

  public BlockStatement getBlock() {
    return block;
  }
  
}