/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.syntax;

import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;

;

/**
 * @author Kota Mizushima
 * Date: 2005/04/09
 */
public class TypeArgument extends SimpleAbstractSyntaxTreeNode{
  private TypeSpecifier[] bounds;
  
  public TypeArgument(TypeSpecifier[] bounds) {
  }
  
  public TypeSpecifier getBound(int index){
    return bounds[index];
  }
  
  public int getSizeOfBounds(){
    return bounds.length;
  }
  
  public boolean hasBounds(){
    return bounds.length > 0;
  }
  
  public Object accept(ASTVisitor visitor, Object context){
    return visitor.visit(this, context);
  }
  
}
