/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Kota Mizushima
 * Date: 2005/04/08
 */
public class CommandLineParser {
  
  private final OptionConfiguration[] configurations;
  
  public CommandLineParser(OptionConfiguration[] configurations) {
    this.configurations = configurations;
  }
  
  private static boolean isOptionName(String name){
    return name.startsWith("-");
  }
  
  public ParseResult parse(String[] commandLine){
    Map noArgumentOptions = new HashMap();
    Map options = new HashMap();
    List arguments = new ArrayList();
    List lackedOptions = new ArrayList();
    List invalidOptions = new ArrayList();
    for(int i = 0; i < commandLine.length;){
      i += checkArgument(commandLine, i, noArgumentOptions, options, arguments, lackedOptions, invalidOptions);
    }
    
    if(lackedOptions.size() == 0 && invalidOptions.size() == 0){
      return new ParseSuccess(noArgumentOptions, options, arguments);
    }else{
      return new ParseFailure(
        (String[])lackedOptions.toArray(new String[0]), 
        (String[])invalidOptions.toArray(new String[0]));
    }
  }
  
  private OptionConfiguration getConfiguration(String optionName){
    for(int i = 0; i < configurations.length; i++){
      if(configurations[i].getOptionName().equals(optionName)){
        return configurations[i];
      }
    }
    return null;
  }
  
  private int checkArgument(String[] commandLine, int index, Map noArgumentOptions, Map options, List arguments, List lackedOptions, List invalidOptions){
    String param = commandLine[index];
    if(isOptionName(param)){
      OptionConfiguration configuration = getConfiguration(param);
      if(configuration == null){
        invalidOptions.add(param);
        return 1;
      }else if(configuration.requireArgument()){
        if(index + 1 >= commandLine.length){
          lackedOptions.add(param);
        }else{
          options.put(param, commandLine[index + 1]);
        }
        return 2;
      }else{
        noArgumentOptions.put(param, new Object());
        return 1;
      }
    }else{
      arguments.add(param);
      return 1;
    }
  }

}