/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.compiler;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;

import org.onion_lang.onion.compiler.utility.*;
import org.onion_lang.onion.compiler.utility.Strings;
import org.onion_lang.onion.tools.OnionCompilerFrontend;

import junit.framework.TestCase;

/**
 * @author Kota Mizushima
 * Date: 2005/04/09
 */
public class TestOnionCompiler extends TestCase {
  private static final String TEST_DIRECTORY = "testTemp";
  private OnionCompilerFrontend testTarget;
  private static FileFilter srcFilter = new FileFilter(){
    public boolean accept(File path) {
      return path.isFile() && path.getName().endsWith(".on");
    }
  };
  private static FileFilter destFilter = new FileFilter(){
    public boolean accept(File path) {
      return path.isFile() && path.getName().endsWith(".class");
    }
  };

  public static void main(String[] args) {
    junit.textui.TestRunner.run(TestOnionCompiler.class);
  }

  protected void setUp() throws Exception {
    new File(TEST_DIRECTORY).mkdirs();
    testTarget = new OnionCompilerFrontend();
  }

  protected void tearDown() throws Exception {
    File[] files = new File(TEST_DIRECTORY).listFiles();
    for(int i = 0; i < files.length; i++){
      files[i].delete();
    }
    new File(TEST_DIRECTORY).delete();
  }

  public TestOnionCompiler(String arg0) {
    super(arg0);
  }
  
  private static String[] getExampleSources(String exampleDirectory) throws IOException{
    File[] files = new File(exampleDirectory).listFiles(srcFilter);
    String[] fileNames = new String[files.length];
    for (int i = 0; i < fileNames.length; i++) {
      fileNames[i] = files[i].getCanonicalPath();
    }
    return fileNames;
  }

  public void testCompile() throws IOException, ClassNotFoundException {
    String[] fileNames = getExampleSources("example");
    String[] args = {"-d", TEST_DIRECTORY, "-encoding", "Shift_JIS"};
    int result = testTarget.run(Strings.append(args, fileNames));
    assertEquals(result, 0);
    File testDirectory = new File(TEST_DIRECTORY);
    File[] files = testDirectory.listFiles(destFilter);
    ClassLoader loader = new URLClassLoader(new URL[]{testDirectory.toURL()});
    for(int i = 0; i < files.length; i++){
      loader.loadClass(Paths.extCutName(files[i].getName()));
    }
  }
}
