/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.compiler.environment;

import org.onion_lang.onion.compiler.environment.SynchronizationStack;
import org.onion_lang.onion.lang.syntax.SynchronizedStatement;

import junit.framework.TestCase;

/**
 * @author Kota Mizushima
 * Date: 2005/04/07
 */
public class TestSynchronizationStack extends TestCase {
  private SynchronizationStack testTarget;
  private SynchronizedStatement statement;
  private SynchronizationStack previous;

  public static void main(String[] args) {
    junit.textui.TestRunner.run(TestSynchronizationStack.class);
  }

  protected void setUp() throws Exception {
    previous = new SynchronizationStack(null, null);
    statement = new SynchronizedStatement(null, null);
    testTarget = new SynchronizationStack(statement, previous);
  }

  protected void tearDown() throws Exception {
  }
  
  public void testGetPrevious(){
    assertEquals(previous, testTarget.getPrevious());
  }
  
  public void testGetStatement(){
    assertEquals(statement, testTarget.getStatement());
  }

  public TestSynchronizationStack(String arg0) {
    super(arg0);
  }

}
