/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.compiler;

import java.io.BufferedReader;
import java.io.IOException;
import java.text.MessageFormat;
import org.onion_lang.onion.compiler.CompilationConfiguration;
import org.onion_lang.onion.compiler.CompiledClass;
import org.onion_lang.onion.compiler.phase.CodeAnalysisPhase;
import org.onion_lang.onion.compiler.phase.CodeGenerationPhase;
import org.onion_lang.onion.compiler.phase.ParsingPhase;
import org.onion_lang.onion.compiler.problem.CompilationFailureException;
import org.onion_lang.onion.compiler.problem.CompilationProblem;
import org.onion_lang.onion.compiler.utility.Inputs;
import org.onion_lang.onion.compiler.utility.Strings;
import org.onion_lang.onion.compiler.utility.Systems;
import org.onion_lang.onion.lang.kernel.ClassNode;
import org.onion_lang.onion.lang.syntax.CompilationUnit;
import org.onion_lang.onion.lang.syntax.SourcePosition;

public class OnionCompiler {
    private CompilationConfiguration configuration;

    public OnionCompiler(CompilationConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setConfiguration(CompilationConfiguration configuration) {
        this.configuration = configuration;
    }

    public CompilationConfiguration getConfiguration() {
        return this.configuration;
    }

    public CompiledClass[] compile(String[] fileNames) {
        try {
            ParsingPhase parsing = new ParsingPhase(this.configuration);
            CompilationUnit[] units = parsing.process(fileNames);
            CodeAnalysisPhase analysis = new CodeAnalysisPhase(this.configuration);
            ClassNode[] classes = analysis.process(units);
            CodeGenerationPhase generation = new CodeGenerationPhase(this.configuration);
            CompiledClass[] classFiles = generation.process(classes);
            return classFiles;
        }
        catch (CompilationFailureException ex) {
            for (int i = 0; i < ex.getSizeOfProblems(); ++i) {
                CompilationProblem problem = ex.getProblem(i);
                SourcePosition position = problem.getSourcePosition();
                String sourceFile = problem.getSourceFile();
                StringBuffer message = new StringBuffer();
                if (sourceFile == null) {
                    message.append(MessageFormat.format("{0}", problem.getMessage()));
                } else {
                    String line = null;
                    try {
                        line = position != null ? this.findLine(sourceFile, position.getLine()) : "";
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    line = line != null ? line : "";
                    message.append(MessageFormat.format("{0}: {1},{2}: {3}", sourceFile, position != null ? Integer.toString(position.getLine()) : "", position != null ? Integer.toString(position.getColumn()) : "", problem.getMessage()));
                    message.append(Systems.getLineSeparator());
                    message.append("\t\t");
                    message.append(line);
                    message.append(Systems.getLineSeparator());
                    message.append("\t\t");
                    if (position != null) {
                        message.append(this.createCursor(position.getColumn()));
                    }
                }
                System.err.println(new String(message));
            }
            return null;
        }
    }

    private String createCursor(int column) {
        return Strings.repeat(" ", column - 1) + "^";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findLine(String sourceFile, int lineNumber) throws IOException {
        BufferedReader reader = Inputs.newReader(sourceFile);
        try {
            String line = null;
            for (int countLineNumber = 1; (line = reader.readLine()) != null && countLineNumber != lineNumber; ++countLineNumber) {
            }
            String string = line;
            return string;
        }
        finally {
            reader.close();
        }
    }
}

