/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.compiler.environment;

import com.sun.org.apache.bcel.internal.util.ClassPath;
import java.io.File;
import java.io.IOException;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.Repository;

public class ClassFileTable {
    private Repository repository;
    private ClassPath classPath;

    public ClassFileTable(String classPath) {
        this.classPath = new ClassPath(classPath);
        this.repository = org.apache.bcel.Repository.getRepository();
    }

    public JavaClass load(String className) {
        JavaClass javaClass = this.lookup(className);
        if (javaClass == null) {
            javaClass = this.addNewClass(className);
        }
        return javaClass;
    }

    public JavaClass lookup(String className) {
        try {
            return this.repository.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private JavaClass addNewClass(String className) {
        try {
            ClassPath.ClassFile classFile = this.classPath.getClassFile(className);
            ClassParser parser = new ClassParser(classFile.getInputStream(), new File(classFile.getPath()).getName());
            JavaClass javaClass = parser.parse();
            this.repository.storeClass(parser.parse());
            return javaClass;
        }
        catch (IOException e) {
            return null;
        }
        catch (ClassFormatException e) {
            return null;
        }
    }
}

