/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.compiler.environment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.onion_lang.onion.compiler.environment.MethodSymbolComparator;
import org.onion_lang.onion.compiler.environment.ParameterMatcher;
import org.onion_lang.onion.compiler.environment.StandardParameterMatcher;
import org.onion_lang.onion.lang.kernel.ExpressionNode;
import org.onion_lang.onion.lang.kernel.type.ClassSymbol;
import org.onion_lang.onion.lang.kernel.type.MethodSymbol;
import org.onion_lang.onion.lang.kernel.type.ObjectSymbol;
import org.onion_lang.onion.lang.kernel.type.TypeRules;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

public class MethodFinder {
    private static Comparator sorter = new Comparator(){

        public int compare(Object method1, Object method2) {
            MethodSymbol m1 = (MethodSymbol)method1;
            MethodSymbol m2 = (MethodSymbol)method2;
            TypeSymbol[] arg1 = m1.getArguments();
            TypeSymbol[] arg2 = m2.getArguments();
            int length = arg1.length;
            if (MethodFinder.isAllSuperType(arg2, arg1)) {
                return -1;
            }
            if (MethodFinder.isAllSuperType(arg1, arg2)) {
                return 1;
            }
            return 0;
        }
    };
    private ParameterMatcher matcher = new StandardParameterMatcher();

    public MethodSymbol[] lookup(ObjectSymbol target, String name, ExpressionNode[] arguments) {
        TreeSet methods = new TreeSet(new MethodSymbolComparator());
        this.lookup(methods, target, name, arguments);
        ArrayList selectedMethods = new ArrayList();
        selectedMethods.addAll(methods);
        Collections.sort(selectedMethods, sorter);
        return selectedMethods.toArray(new MethodSymbol[0]);
    }

    public int compareSpecific(MethodSymbol method1, MethodSymbol method2) {
        return sorter.compare(method1, method2);
    }

    public boolean isAmbiguous(MethodSymbol[] methods) {
        return methods.length > 1 && this.compareSpecific(methods[0], methods[1]) >= 0;
    }

    private void lookup(Set methods, ObjectSymbol target, String name, ExpressionNode[] arguments) {
        if (target == null) {
            return;
        }
        MethodSymbol[] ms = target.getMethods();
        for (int i = 0; i < ms.length; ++i) {
            MethodSymbol m = ms[i];
            if (!m.getName().equals(name) || !this.matcher.matches(m.getArguments(), arguments)) continue;
            methods.add(m);
        }
        ClassSymbol superClass = target.getSuperClass();
        this.lookup(methods, superClass, name, arguments);
        ClassSymbol[] interfaces = target.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            this.lookup(methods, interfaces[i], name, arguments);
        }
    }

    private static boolean isAllSuperType(TypeSymbol[] arg1, TypeSymbol[] arg2) {
        for (int i = 0; i < arg1.length; ++i) {
            if (TypeRules.isSuperType(arg1[i], arg2[i])) continue;
            return false;
        }
        return true;
    }
}

