/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.compiler.phase;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DADD;
import org.apache.bcel.generic.DCMPL;
import org.apache.bcel.generic.DDIV;
import org.apache.bcel.generic.DMUL;
import org.apache.bcel.generic.DREM;
import org.apache.bcel.generic.DSUB;
import org.apache.bcel.generic.FADD;
import org.apache.bcel.generic.FCMPL;
import org.apache.bcel.generic.FDIV;
import org.apache.bcel.generic.FMUL;
import org.apache.bcel.generic.FREM;
import org.apache.bcel.generic.FSUB;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IADD;
import org.apache.bcel.generic.IAND;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.IDIV;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IFGE;
import org.apache.bcel.generic.IFGT;
import org.apache.bcel.generic.IFLE;
import org.apache.bcel.generic.IFLT;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.IF_ACMPEQ;
import org.apache.bcel.generic.IF_ACMPNE;
import org.apache.bcel.generic.IF_ICMPEQ;
import org.apache.bcel.generic.IF_ICMPGE;
import org.apache.bcel.generic.IF_ICMPGT;
import org.apache.bcel.generic.IF_ICMPLE;
import org.apache.bcel.generic.IF_ICMPLT;
import org.apache.bcel.generic.IF_ICMPNE;
import org.apache.bcel.generic.IMUL;
import org.apache.bcel.generic.IOR;
import org.apache.bcel.generic.IREM;
import org.apache.bcel.generic.ISUB;
import org.apache.bcel.generic.IXOR;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.LADD;
import org.apache.bcel.generic.LAND;
import org.apache.bcel.generic.LCMP;
import org.apache.bcel.generic.LCONST;
import org.apache.bcel.generic.LDIV;
import org.apache.bcel.generic.LMUL;
import org.apache.bcel.generic.LOR;
import org.apache.bcel.generic.LREM;
import org.apache.bcel.generic.LSUB;
import org.apache.bcel.generic.LXOR;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;
import org.onion_lang.onion.compiler.CompilationConfiguration;
import org.onion_lang.onion.compiler.CompiledClass;
import org.onion_lang.onion.compiler.environment.ClosureLocalBinding;
import org.onion_lang.onion.compiler.environment.CodeProxy;
import org.onion_lang.onion.compiler.environment.LocalBinding;
import org.onion_lang.onion.compiler.environment.LocalFrame;
import org.onion_lang.onion.compiler.environment.MethodSymbolComparator;
import org.onion_lang.onion.compiler.environment.SymbolGenerator;
import org.onion_lang.onion.compiler.environment.VMTypeBridge;
import org.onion_lang.onion.compiler.utility.Methods;
import org.onion_lang.onion.compiler.utility.Systems;
import org.onion_lang.onion.lang.kernel.ArrayAssignmentNode;
import org.onion_lang.onion.lang.kernel.ArrayLengthNode;
import org.onion_lang.onion.lang.kernel.ArrayRefNode;
import org.onion_lang.onion.lang.kernel.BinaryExpressionNode;
import org.onion_lang.onion.lang.kernel.BlockNode;
import org.onion_lang.onion.lang.kernel.BooleanNode;
import org.onion_lang.onion.lang.kernel.CastNode;
import org.onion_lang.onion.lang.kernel.ClassNode;
import org.onion_lang.onion.lang.kernel.ClosureNode;
import org.onion_lang.onion.lang.kernel.ConstructorNode;
import org.onion_lang.onion.lang.kernel.DoubleNode;
import org.onion_lang.onion.lang.kernel.EmptyNode;
import org.onion_lang.onion.lang.kernel.ExpressionNode;
import org.onion_lang.onion.lang.kernel.ExpressionStatementNode;
import org.onion_lang.onion.lang.kernel.FieldAssignmentNode;
import org.onion_lang.onion.lang.kernel.FieldNode;
import org.onion_lang.onion.lang.kernel.FieldRefNode;
import org.onion_lang.onion.lang.kernel.FloatNode;
import org.onion_lang.onion.lang.kernel.IfNode;
import org.onion_lang.onion.lang.kernel.IntegerNode;
import org.onion_lang.onion.lang.kernel.IsInstanceNode;
import org.onion_lang.onion.lang.kernel.ListNode;
import org.onion_lang.onion.lang.kernel.LocalAssignmentNode;
import org.onion_lang.onion.lang.kernel.LocalRefNode;
import org.onion_lang.onion.lang.kernel.LongNode;
import org.onion_lang.onion.lang.kernel.LoopNode;
import org.onion_lang.onion.lang.kernel.MethodCallNode;
import org.onion_lang.onion.lang.kernel.MethodNode;
import org.onion_lang.onion.lang.kernel.NewArrayNode;
import org.onion_lang.onion.lang.kernel.NewNode;
import org.onion_lang.onion.lang.kernel.NullNode;
import org.onion_lang.onion.lang.kernel.ReturnNode;
import org.onion_lang.onion.lang.kernel.SelfNode;
import org.onion_lang.onion.lang.kernel.StatementNode;
import org.onion_lang.onion.lang.kernel.StaticFieldRefNode;
import org.onion_lang.onion.lang.kernel.StaticMethodCallNode;
import org.onion_lang.onion.lang.kernel.StringNode;
import org.onion_lang.onion.lang.kernel.SuperInitNode;
import org.onion_lang.onion.lang.kernel.SynchronizedNode;
import org.onion_lang.onion.lang.kernel.ThrowNode;
import org.onion_lang.onion.lang.kernel.TryNode;
import org.onion_lang.onion.lang.kernel.UnaryExpressionNode;
import org.onion_lang.onion.lang.kernel.type.ArraySymbol;
import org.onion_lang.onion.lang.kernel.type.BasicSymbol;
import org.onion_lang.onion.lang.kernel.type.ClassSymbol;
import org.onion_lang.onion.lang.kernel.type.ConstructorSymbol;
import org.onion_lang.onion.lang.kernel.type.FieldSymbol;
import org.onion_lang.onion.lang.kernel.type.MethodSymbol;
import org.onion_lang.onion.lang.kernel.type.ObjectSymbol;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;
import org.onion_lang.onion.lang.syntax.Modifier;

public class CodeGenerationPhase
implements BinaryExpressionNode.Constants {
    private CompilationConfiguration config;
    private List compiledClasses = new ArrayList();
    private SymbolGenerator generator;
    private static Map basicTypeTable = new HashMap(){
        {
            this.put(BasicSymbol.BYTE, BasicType.BYTE);
            this.put(BasicSymbol.SHORT, BasicType.SHORT);
            this.put(BasicSymbol.CHAR, BasicType.CHAR);
            this.put(BasicSymbol.INT, BasicType.INT);
            this.put(BasicSymbol.LONG, BasicType.LONG);
            this.put(BasicSymbol.FLOAT, BasicType.FLOAT);
            this.put(BasicSymbol.DOUBLE, BasicType.DOUBLE);
            this.put(BasicSymbol.BOOLEAN, BasicType.BOOLEAN);
            this.put(BasicSymbol.VOID, BasicType.VOID);
        }
    };
    private static Map unboxingMethods = new HashMap(){
        {
            this.put("java.lang.Byte", "byteValue");
            this.put("java.lang.Short", "shortValue");
            this.put("java.lang.Character", "charValue");
            this.put("java.lang.Integer", "intValue");
            this.put("java.lang.Long", "longValue");
            this.put("java.lang.Float", "floatValue");
            this.put("java.lang.Double", "doubleValue");
            this.put("java.lang.Boolean", "booleanValue");
        }
    };
    private static final String FRAME_PREFIX = "frame";
    private VMTypeBridge bridge;

    public CodeGenerationPhase(CompilationConfiguration config) {
        this.config = config;
        this.bridge = new VMTypeBridge();
    }

    public CompiledClass[] process(ClassNode[] classes) {
        this.compiledClasses.clear();
        String base = this.config.getOutputDirectory();
        base = base != null ? base : ".";
        base = base + Systems.getFileSeparator();
        for (int i = 0; i < classes.length; ++i) {
            this.codeClass(classes[i]);
        }
        CompiledClass[] classFiles = new CompiledClass[this.compiledClasses.size()];
        for (int i = 0; i < this.compiledClasses.size(); ++i) {
            JavaClass clazz = (JavaClass)this.compiledClasses.get(i);
            String outDir = this.getOutputDir(base, clazz.getClassName());
            classFiles[i] = new CompiledClass(clazz.getClassName(), outDir, clazz.getBytes());
        }
        return classFiles;
    }

    private String getOutputDir(String base, String fqcn) {
        String packageName = this.getPackageName(fqcn);
        return base + packageName.replace(".", Systems.getFileSeparator());
    }

    private String getPackageName(String fqcn) {
        int index = fqcn.lastIndexOf(".");
        if (index < 0) {
            return "";
        }
        return fqcn.substring(0, index);
    }

    private static Integer id(int number) {
        return new Integer(number);
    }

    private int classModifier(ClassNode node) {
        int modifier = node.getModifier();
        modifier = CodeGenerationPhase.toJavaModifier(modifier);
        return modifier |= !Modifier.isInternal(modifier |= node.isInterface() ? 512 : modifier) ? 1 : modifier;
    }

    public void codeClass(ClassNode node) {
        int modifier = this.classModifier(node);
        String className = node.getName();
        this.generator = new SymbolGenerator(className + "Closure");
        String superClass = node.getSuperClass().getName();
        String[] interfaces = this.namesOf(node.getInterfaces());
        String file = node.getSourceFile();
        ClassGen gen = new ClassGen(className, superClass, file, modifier, interfaces);
        ConstructorSymbol[] constructors = node.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            this.codeConstructor(gen, (ConstructorNode)constructors[i]);
        }
        MethodSymbol[] methods = node.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            this.codeMethod(gen, (MethodNode)methods[i]);
        }
        FieldSymbol[] fields = node.getFields();
        for (int i = 0; i < fields.length; ++i) {
            this.codeField(gen, (FieldNode)fields[i]);
        }
        this.compiledClasses.add(gen.getJavaClass());
    }

    public InstructionHandle codeExpressions(ExpressionNode[] nodes, CodeProxy code) {
        InstructionHandle start;
        if (nodes.length > 0) {
            start = this.codeExpression(nodes[0], code);
            for (int i = 1; i < nodes.length; ++i) {
                this.codeExpression(nodes[i], code);
            }
        } else {
            start = code.append(InstructionConstants.NOP);
        }
        return start;
    }

    public void codeConstructor(ClassGen gen, ConstructorNode node) {
        CodeProxy code = new CodeProxy(gen.getConstantPool());
        LocalFrame frame = node.getFrame();
        code.setFrame(frame);
        String[] args = new String[node.getArguments().length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = "arg" + i;
        }
        String className = node.getClassType().getName();
        int modifier = CodeGenerationPhase.toJavaModifier(node.getModifier());
        Type[] arguments = this.typesOf(node.getArguments());
        String name = "<init>";
        MethodGen method = new MethodGen(modifier, Type.VOID, arguments, args, name, className, code.getCode(), gen.getConstantPool());
        if (frame.isClosed()) {
            int frameObjectIndex = this.frameObjectIndex(1, node.getArguments());
            code.setFrameObjectIndex(frameObjectIndex);
            code.setIndexTable(this.indexTableFor(frame));
            this.appendInitialCode(code, frame, arguments, 1);
        } else {
            code.setIndexTable(this.indexTableFor(1, frame));
        }
        code.setMethod(method);
        SuperInitNode init = node.getSuperInitializer();
        className = init.getClassType().getName();
        arguments = this.typesOf(init.getArguments());
        code.append(InstructionConstants.ALOAD_0);
        this.codeExpressions(init.getExpressions(), code);
        code.appendInvoke(className, name, Type.VOID, arguments, (short)183);
        this.codeBlock(node.getBlock(), code);
        method.setMaxLocals();
        method.setMaxStack();
        code.appendReturn(this.typeOf(BasicSymbol.VOID));
        gen.addMethod(method.getMethod());
    }

    public void codeMethod(ClassGen gen, MethodNode node) {
        CodeProxy code = new CodeProxy(gen.getConstantPool());
        LocalFrame frame = node.getFrame();
        code.setFrame(frame);
        int modifier = CodeGenerationPhase.toJavaModifier(node.getModifier());
        Type returned = this.typeOf(node.getReturnType());
        Type[] arguments = this.typesOf(node.getArguments());
        String[] argNames = this.names(arguments.length);
        String name = node.getName();
        String className = node.getClassType().getName();
        MethodGen method = new MethodGen(modifier, returned, arguments, argNames, name, className, code.getCode(), gen.getConstantPool());
        code.setMethod(method);
        if (!Modifier.isAbstract(node.getModifier())) {
            if (frame.isClosed()) {
                int origin;
                if (Modifier.isStatic(node.getModifier())) {
                    code.setFrameObjectIndex(this.frameObjectIndex(0, node.getArguments()));
                    origin = 0;
                } else {
                    code.setFrameObjectIndex(this.frameObjectIndex(1, node.getArguments()));
                    origin = 1;
                }
                code.setIndexTable(this.indexTableFor(frame));
                this.appendInitialCode(code, frame, arguments, origin);
            } else if (Modifier.isStatic(node.getModifier())) {
                code.setIndexTable(this.indexTableFor(0, frame));
            } else {
                code.setIndexTable(this.indexTableFor(1, frame));
            }
            this.codeBlock(node.getBlock(), code);
            method.setMaxLocals();
            method.setMaxStack();
        }
        gen.addMethod(method.getMethod());
    }

    private void appendInitialCode(CodeProxy code, LocalFrame frame, Type[] arguments, int origin) {
        int frameObjectIndex = code.getFrameObjectIndex();
        code.appendConstant(new Integer(frame.entries().length));
        code.appendNewArray(Type.OBJECT, (short)1);
        code.appendDup(1);
        code.appendStore(new ArrayType(Type.OBJECT, 1), frameObjectIndex);
        int index = origin;
        for (int i = 0; i < arguments.length; ++i) {
            Type arg = arguments[i];
            code.appendDup(1);
            code.appendConstant(new Integer(i));
            if (arguments[i] instanceof BasicType) {
                ObjectType boxed = code.boxingType(arg);
                code.appendNew(boxed);
                code.appendDup(1);
                code.appendLoad(arg, index);
                code.appendInvoke(boxed.getClassName(), "<init>", Type.VOID, new Type[]{arg}, (short)183);
            } else {
                code.appendLoad(arg, index);
            }
            code.appendArrayStore(Type.OBJECT);
            if (arguments[i] == Type.DOUBLE || arguments[i] == Type.LONG) {
                i += 2;
                continue;
            }
            ++i;
        }
    }

    private static Set intefaceMethods(ClassSymbol type) {
        TreeSet methods = new TreeSet(new MethodSymbolComparator());
        CodeGenerationPhase.collectInterfaceMethods(type, methods);
        return methods;
    }

    private static void collectInterfaceMethods(ClassSymbol type, Set set) {
        MethodSymbol[] methods = type.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            set.add(methods[i]);
        }
        ClassSymbol[] interfaces = type.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            CodeGenerationPhase.collectInterfaceMethods(interfaces[i], set);
        }
    }

    private void implementsMethods(ClassGen gen, MethodSymbol[] methods) {
        for (int i = 0; i < methods.length; ++i) {
            MethodSymbol method = methods[i];
            Type returnType = this.typeOf(method.getReturnType());
            String name = method.getName();
            Type[] args = this.typesOf(method.getArguments());
            String[] argNames = this.names(args.length);
            CodeProxy code = new CodeProxy(gen.getConstantPool());
            MethodGen mgen = new MethodGen(1, returnType, args, argNames, name, gen.getClassName(), code.getCode(), gen.getConstantPool());
            code.appendDefaultValue(returnType);
            code.appendReturn(returnType);
            mgen.setMaxLocals();
            mgen.setMaxStack();
            gen.addMethod(mgen.getMethod());
        }
    }

    public InstructionHandle codeClosure(ClosureNode node, CodeProxy code) {
        ClassSymbol classType = node.getClassType();
        String closureName = this.generator.generate();
        Type[] arguments = this.typesOf(node.getArguments());
        ClassGen gen = new ClassGen(closureName, "java.lang.Object", "<generated>", 1, new String[]{classType.getName()});
        Set methods = Methods.intefaceMethods(classType);
        methods.remove(node.getMethod());
        this.implementsMethods(gen, methods.toArray(new MethodSymbol[0]));
        LocalFrame frame = node.getFrame();
        int depth = frame.depth();
        for (int i = 1; i <= depth; ++i) {
            FieldGen field = new FieldGen(2, new ArrayType("java.lang.Object", 1), FRAME_PREFIX + depth, gen.getConstantPool());
            gen.addField(field.getField());
        }
        Type[] types = this.closureArguments(depth);
        MethodGen method = this.createClosureConstructor(closureName, types, gen.getConstantPool());
        gen.addMethod(method.getMethod());
        CodeProxy closureCode = new CodeProxy(gen.getConstantPool());
        method = new MethodGen(1, this.typeOf(node.getReturnType()), arguments, this.names(arguments.length), node.getName(), closureName, closureCode.getCode(), gen.getConstantPool());
        closureCode.setMethod(method);
        closureCode.setFrame(frame);
        if (frame.isClosed()) {
            int frameObjectIndex = this.frameObjectIndex(1, node.getArguments());
            closureCode.setFrameObjectIndex(frameObjectIndex);
            closureCode.setIndexTable(this.indexTableFor(frame));
            this.appendInitialCode(closureCode, frame, arguments, 1);
        } else {
            closureCode.setIndexTable(this.indexTableFor(1, frame));
        }
        this.codeStatement(node.getBlock(), closureCode);
        method.setMaxLocals();
        method.setMaxStack();
        gen.addMethod(method.getMethod());
        this.compiledClasses.add(gen.getJavaClass());
        InstructionHandle start = code.appendNew(new ObjectType(closureName));
        code.appendDup(1);
        String name = code.getMethod().getClassName();
        int index = code.getFrameObjectIndex();
        code.appendLoad(new ArrayType("java.lang.Object", 1), index);
        for (int i = 1; i < depth; ++i) {
            code.appendGetField(name, FRAME_PREFIX + i, new ArrayType("java.lang.Object", 1));
        }
        code.appendInvoke(closureName, "<init>", Type.VOID, this.closureArguments(depth), (short)183);
        return start;
    }

    private Type[] closureArguments(int size) {
        Type[] arguments = new Type[size];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = new ArrayType("java.lang.Object", 1);
        }
        return arguments;
    }

    private InstructionHandle codeList(ListNode node, CodeProxy code) {
        ObjectType listType = (ObjectType)this.typeOf(node.type());
        InstructionHandle start = code.appendNew("java.util.ArrayList");
        code.appendDup(1);
        code.appendInvoke("java.util.ArrayList", "<init>", Type.VOID, new Type[0], (short)183);
        ExpressionNode[] elements = node.getElements();
        for (int i = 0; i < elements.length; ++i) {
            code.appendDup(1);
            this.codeExpression(elements[i], code);
            code.appendInvoke(listType.getClassName(), "add", Type.BOOLEAN, new Type[]{Type.OBJECT}, (short)185);
            code.appendPop(1);
        }
        return start;
    }

    private String[] names(int size) {
        String[] names = new String[size];
        for (int i = 0; i < names.length; ++i) {
            names[i] = "args" + size;
        }
        return names;
    }

    private MethodGen createClosureConstructor(String className, Type[] types, ConstantPoolGen pool) {
        String[] argNames = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            argNames[i] = FRAME_PREFIX + i;
        }
        CodeProxy code = new CodeProxy(pool);
        MethodGen constructor = new MethodGen(1, Type.VOID, types, argNames, "<init>", className, code.getCode(), pool);
        boolean index = true;
        code.appendThis();
        code.appendInvoke(Type.OBJECT.getClassName(), "<init>", Type.VOID, new Type[0], (short)183);
        for (int i = 0; i < types.length; ++i) {
            code.appendThis();
            code.appendLoad(types[i], i + 1);
            code.appendPutField(className, FRAME_PREFIX + (i + 1), types[i]);
        }
        code.append(InstructionConstants.RETURN);
        constructor.setMaxLocals();
        constructor.setMaxStack();
        return constructor;
    }

    public void codeField(ClassGen gen, FieldNode node) {
        FieldGen field = new FieldGen(CodeGenerationPhase.toJavaModifier(node.getModifier()), this.typeOf(node.getType()), node.getName(), gen.getConstantPool());
        gen.addField(field.getField());
    }

    public InstructionHandle codeBlock(BlockNode node, CodeProxy code) {
        InstructionHandle start;
        if (node.statements.length > 0) {
            start = this.codeStatement(node.statements[0], code);
            for (int i = 1; i < node.statements.length; ++i) {
                this.codeStatement(node.statements[i], code);
            }
        } else {
            start = code.append(InstructionConstants.NOP);
        }
        return start;
    }

    public InstructionHandle codeExpressionStatement(ExpressionStatementNode node, CodeProxy code) {
        InstructionHandle start = this.codeExpression(node.expression, code);
        TypeSymbol type = node.expression.type();
        if (type != BasicSymbol.VOID) {
            if (this.isWideType(type)) {
                code.append(InstructionConstants.POP2);
            } else {
                code.append(InstructionConstants.POP);
            }
        }
        return start;
    }

    public InstructionHandle codeStatement(StatementNode node, CodeProxy code) {
        InstructionHandle start = node instanceof BlockNode ? this.codeBlock((BlockNode)node, code) : (node instanceof ExpressionStatementNode ? this.codeExpressionStatement((ExpressionStatementNode)node, code) : (node instanceof IfNode ? this.codeIf((IfNode)node, code) : (node instanceof LoopNode ? this.codeLoop((LoopNode)node, code) : (node instanceof EmptyNode ? this.codeEmpty((EmptyNode)node, code) : (node instanceof ReturnNode ? this.codeReturn((ReturnNode)node, code) : (node instanceof SynchronizedNode ? this.codeSynchronized((SynchronizedNode)node, code) : (node instanceof ThrowNode ? this.codeThrowNode((ThrowNode)node, code) : (node instanceof TryNode ? this.codeTry((TryNode)node, code) : code.append(InstructionConstants.NOP)))))))));
        return start;
    }

    public InstructionHandle codeReturn(ReturnNode node, CodeProxy code) {
        InstructionHandle start;
        if (node.expression != null) {
            start = this.codeExpression(node.expression, code);
            Type type = this.typeOf(node.expression.type());
            code.appendReturn(type);
        } else {
            start = code.append(InstructionConstants.RETURN);
        }
        return start;
    }

    public InstructionHandle codeSynchronized(SynchronizedNode node, CodeProxy code) {
        return null;
    }

    public InstructionHandle codeThrowNode(ThrowNode node, CodeProxy code) {
        InstructionHandle start = this.codeExpression(node.expression, code);
        code.append(InstructionConstants.ATHROW);
        return start;
    }

    public InstructionHandle codeTry(TryNode node, CodeProxy code) {
        InstructionHandle start = this.codeStatement(node.tryStatement, code);
        BranchHandle to = code.append(new GOTO(null));
        int length = node.catchTypes.length;
        BranchHandle[] catchEnds = new BranchHandle[length];
        for (int i = 0; i < length; ++i) {
            ClosureLocalBinding bind = node.catchTypes[i];
            int index = code.getIndexTable()[bind.getIndex()];
            ObjectType type = (ObjectType)this.typeOf(bind.getType());
            InstructionHandle target = code.appendStore(type, index);
            code.addExceptionHandler(start, to, target, type);
            this.codeStatement(node.catchStatements[i], code);
            catchEnds[i] = code.append(new GOTO(null));
        }
        InstructionHandle end = code.append(InstructionConstants.NOP);
        to.setTarget(end);
        for (int i = 0; i < catchEnds.length; ++i) {
            catchEnds[i].setTarget(end);
        }
        return start;
    }

    public InstructionHandle codeEmpty(EmptyNode node, CodeProxy code) {
        return code.append(InstructionConstants.NOP);
    }

    public InstructionHandle codeIf(IfNode node, CodeProxy code) {
        InstructionHandle start = this.codeExpression(node.condition, code);
        BranchHandle toThen = code.append(new IFNE(null));
        if (node.elseStatement != null) {
            this.codeStatement(node.elseStatement, code);
        }
        BranchHandle toEnd = code.append(new GOTO(null));
        toThen.setTarget(this.codeStatement(node.thenStatement, code));
        toEnd.setTarget(code.append(new NOP()));
        return start;
    }

    public InstructionHandle codeLoop(LoopNode node, CodeProxy code) {
        InstructionHandle start = this.codeExpression(node.condition, code);
        BranchHandle branch = code.append(new IFEQ(null));
        this.codeStatement(node.stmt, code);
        code.append(new GOTO(start));
        InstructionHandle end = code.append(InstructionConstants.NOP);
        branch.setTarget(end);
        return start;
    }

    private static int toJavaModifier(int src) {
        int modifier = 0;
        return modifier |= Modifier.isFinal(src) ? 16 : (modifier |= Modifier.isAbstract(src) ? 1024 : (modifier |= Modifier.isSynchronized(src) ? 32 : (modifier |= Modifier.isStatic(src) ? 8 : (modifier |= Modifier.isPublic(src) ? 1 : (modifier |= Modifier.isProtected(src) ? 4 : (modifier |= Modifier.isPrivate(src) ? 2 : modifier))))));
    }

    private String nameOf(ClassSymbol symbol) {
        return symbol.getName();
    }

    private String[] namesOf(ClassSymbol[] symbols) {
        String[] names = new String[symbols.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.nameOf(symbols[i]);
        }
        return names;
    }

    public InstructionHandle codeExpression(ExpressionNode node, CodeProxy code) {
        InstructionHandle start;
        if (node instanceof BinaryExpressionNode) {
            start = this.codeBinaryExpression((BinaryExpressionNode)node, code);
        } else if (node instanceof UnaryExpressionNode) {
            start = this.codeUnaryExpression((UnaryExpressionNode)node, code);
        } else if (node instanceof LocalAssignmentNode) {
            start = this.codeLocalAssign((LocalAssignmentNode)node, code);
        } else if (node instanceof LocalRefNode) {
            start = this.codeLocalRef((LocalRefNode)node, code);
        } else if (node instanceof StaticFieldRefNode) {
            start = this.codeStaticFieldRef((StaticFieldRefNode)node, code);
        } else if (node instanceof FieldRefNode) {
            start = this.codeFieldRef((FieldRefNode)node, code);
        } else if (node instanceof FieldAssignmentNode) {
            start = this.codeFieldAssign((FieldAssignmentNode)node, code);
        } else if (node instanceof MethodCallNode) {
            start = this.codeMethodCall((MethodCallNode)node, code);
        } else if (node instanceof ArrayRefNode) {
            start = this.codeArrayRef((ArrayRefNode)node, code);
        } else if (node instanceof ArrayLengthNode) {
            start = this.codeArrayLengthNode((ArrayLengthNode)node, code);
        } else if (node instanceof ArrayAssignmentNode) {
            start = this.codeArrayAssignment((ArrayAssignmentNode)node, code);
        } else if (node instanceof NewNode) {
            start = this.codeNew((NewNode)node, code);
        } else if (node instanceof NewArrayNode) {
            start = this.codeNewArray((NewArrayNode)node, code);
        } else if (node instanceof ArrayRefNode) {
            start = this.codeNewArray((NewArrayNode)node, code);
        } else if (node instanceof StaticMethodCallNode) {
            start = this.codeStaticMethodCall((StaticMethodCallNode)node, code);
        } else if (node instanceof StringNode) {
            start = this.codeString((StringNode)node, code);
        } else if (node instanceof IntegerNode) {
            start = this.codeInteger((IntegerNode)node, code);
        } else if (node instanceof LongNode) {
            start = this.codeLong((LongNode)node, code);
        } else if (node instanceof FloatNode) {
            start = this.codeFloat((FloatNode)node, code);
        } else if (node instanceof DoubleNode) {
            start = this.codeDouble((DoubleNode)node, code);
        } else if (node instanceof BooleanNode) {
            start = this.codeBoolean((BooleanNode)node, code);
        } else if (node instanceof NullNode) {
            start = this.codeNull((NullNode)node, code);
        } else if (node instanceof CastNode) {
            start = this.codeCast((CastNode)node, code);
        } else if (node instanceof SelfNode) {
            start = this.codeSelf((SelfNode)node, code);
        } else if (node instanceof IsInstanceNode) {
            start = this.codeIsInstance((IsInstanceNode)node, code);
        } else if (node instanceof ClosureNode) {
            start = this.codeClosure((ClosureNode)node, code);
        } else if (node instanceof ListNode) {
            start = this.codeList((ListNode)node, code);
        } else {
            throw new RuntimeException();
        }
        return start;
    }

    public InstructionHandle codeLocalAssign(LocalAssignmentNode node, CodeProxy code) {
        InstructionHandle start = null;
        Type type = this.typeOf(node.type());
        if (node.getFrame() == 0 && !code.getFrame().isClosed()) {
            start = this.codeExpression(node.getValue(), code);
            if (this.isWideType(node.type())) {
                code.append(InstructionConstants.DUP2);
            } else {
                code.append(InstructionConstants.DUP);
            }
            code.appendStore(type, code.getIndexTable()[node.getIndex()]);
        } else {
            if (node.getFrame() == 0 && code.getFrame().isClosed()) {
                int index = code.getFrameObjectIndex();
                start = code.appendLoad(new ArrayType("java.lang.Object", 1), index);
                code.appendConstant(new Integer(code.index(node.getIndex())));
            } else {
                start = code.appendThis();
                code.appendGetField(code.getMethod().getClassName(), FRAME_PREFIX + node.getFrame(), new ArrayType("java.lang.Object", 1));
                code.appendConstant(new Integer(node.getIndex()));
            }
            if (node.isBasicType()) {
                ObjectType boxed = code.boxingType(type);
                code.appendNew(boxed);
                code.appendDup(1);
                this.codeExpression(node.getValue(), code);
                code.appendInvoke(boxed.getClassName(), "<init>", Type.VOID, new Type[]{type}, (short)183);
                code.appendDup_2(1);
                code.appendArrayStore(Type.OBJECT);
                String method = (String)unboxingMethods.get(boxed.getClassName());
                code.appendInvoke(boxed.getClassName(), method, type, new Type[0], (short)182);
            } else {
                this.codeExpression(node.getValue(), code);
                code.appendDup_2(1);
                code.appendArrayStore(Type.OBJECT);
            }
        }
        return start;
    }

    public InstructionHandle codeLocalRef(LocalRefNode node, CodeProxy code) {
        InstructionHandle start = null;
        Type type = this.typeOf(node.type());
        if (node.frame() == 0 && !code.getFrame().isClosed()) {
            start = code.appendLoad(type, code.index(node.index()));
        } else {
            if (node.frame() == 0 && code.getFrame().isClosed()) {
                int index = code.getFrameObjectIndex();
                start = code.appendLoad(new ArrayType("java.lang.Object", 1), index);
                code.appendConstant(new Integer(code.index(node.index())));
            } else {
                start = code.appendThis();
                code.appendGetField(code.getMethod().getClassName(), FRAME_PREFIX + node.frame(), new ArrayType("java.lang.Object", 1));
                code.appendConstant(new Integer(node.index()));
            }
            code.appendArrayLoad(Type.OBJECT);
            if (node.isBasicType()) {
                ObjectType boxed = code.boxingType(type);
                String method = (String)unboxingMethods.get(boxed.getClassName());
                code.appendCast(Type.OBJECT, boxed);
                code.appendInvoke(boxed.getClassName(), method, type, new Type[0], (short)182);
            } else {
                code.appendCast(Type.OBJECT, type);
            }
        }
        return start;
    }

    public InstructionHandle codeStaticFieldRef(StaticFieldRefNode node, CodeProxy code) {
        String classType = node.field.getClassType().getName();
        String name = node.field.getName();
        Type type = this.typeOf(node.type());
        return code.appendGetStatic(classType, name, type);
    }

    public InstructionHandle codeMethodCall(MethodCallNode node, CodeProxy code) {
        InstructionHandle start = this.codeExpression(node.target, code);
        for (int i = 0; i < node.parameters.length; ++i) {
            this.codeExpression(node.parameters[i], code);
        }
        ObjectSymbol classType = (ObjectSymbol)node.target.type();
        short kind = classType.isInterface() ? (short)185 : 182;
        String className = classType.getName();
        String name = node.method.getName();
        Type ret = this.typeOf(node.type());
        Type[] args = this.typesOf(node.method.getArguments());
        code.appendInvoke(className, name, ret, args, kind);
        return start;
    }

    public InstructionHandle codeArrayRef(ArrayRefNode node, CodeProxy code) {
        ArraySymbol targetType = (ArraySymbol)node.getTarget().type();
        InstructionHandle start = this.codeExpression(node.getTarget(), code);
        this.codeExpression(node.getIndex(), code);
        code.appendArrayLoad(this.typeOf(targetType.getBase()));
        return start;
    }

    public InstructionHandle codeArrayLengthNode(ArrayLengthNode node, CodeProxy code) {
        InstructionHandle start = this.codeExpression(node.getTarget(), code);
        code.append(InstructionConstants.ARRAYLENGTH);
        return start;
    }

    public InstructionHandle codeArrayAssignment(ArrayAssignmentNode node, CodeProxy code) {
        ArraySymbol targetType = (ArraySymbol)node.getTarget().type();
        InstructionHandle start = this.codeExpression(node.getTarget(), code);
        code.appendDup(1);
        this.codeExpression(node.getIndex(), code);
        this.codeExpression(node.getValue(), code);
        code.appendArrayStore(this.typeOf(targetType.getBase()));
        return start;
    }

    public InstructionHandle codeNew(NewNode node, CodeProxy code) {
        ClassSymbol type = node.constructor.getClassType();
        InstructionHandle start = code.appendNew((ObjectType)this.typeOf(type));
        code.append(InstructionConstants.DUP);
        for (int i = 0; i < node.parameters.length; ++i) {
            this.codeExpression(node.parameters[i], code);
        }
        String className = type.getName();
        Type[] arguments = this.typesOf(node.constructor.getArguments());
        short kind = 183;
        code.appendInvoke(className, "<init>", Type.VOID, arguments, kind);
        return start;
    }

    public InstructionHandle codeNewArray(NewArrayNode node, CodeProxy code) {
        InstructionHandle start = this.codeExpressions(node.parameters, code);
        ArraySymbol type = node.arrayType;
        code.appendNewArray(this.typeOf(type.getComponent()), (short)node.parameters.length);
        return start;
    }

    public InstructionHandle codeStaticMethodCall(StaticMethodCallNode node, CodeProxy code) {
        InstructionHandle start;
        if (node.parameters.length > 0) {
            start = this.codeExpression(node.parameters[0], code);
            for (int i = 1; i < node.parameters.length; ++i) {
                this.codeExpression(node.parameters[i], code);
            }
        } else {
            start = code.append(InstructionConstants.NOP);
        }
        String className = node.target.getName();
        String name = node.method.getName();
        Type returnType = this.typeOf(node.type());
        Type[] arguments = this.typesOf(node.method.getArguments());
        short kind = 184;
        code.appendInvoke(className, name, returnType, arguments, kind);
        return start;
    }

    public InstructionHandle codeBinaryExpression(BinaryExpressionNode node, CodeProxy code) {
        if (node.getKind() == 5) {
            return this.codeLogicalAnd(node, code);
        }
        if (node.getKind() == 6) {
            return this.codeLogicalOr(node, code);
        }
        ExpressionNode left = node.getLeft();
        ExpressionNode right = node.getRight();
        InstructionHandle start = this.codeExpression(left, code);
        this.codeExpression(right, code);
        switch (node.getKind()) {
            case 0: {
                this.add(code, left.type());
                break;
            }
            case 1: {
                this.sub(code, left.type());
                break;
            }
            case 2: {
                this.mul(code, left.type());
                break;
            }
            case 3: {
                this.div(code, left.type());
                break;
            }
            case 4: {
                this.mod(code, left.type());
                break;
            }
            case 17: {
                this.eq(code, left.type());
                break;
            }
            case 18: {
                this.noteq(code, left.type());
                break;
            }
            case 15: {
                this.lte(code, left.type());
                break;
            }
            case 16: {
                this.gte(code, left.type());
                break;
            }
            case 13: {
                this.lt(code, left.type());
                break;
            }
            case 14: {
                this.gt(code, left.type());
                break;
            }
            case 7: {
                this.bitAnd(code, left.type());
                break;
            }
            case 8: {
                this.bitOr(code, right.type());
                break;
            }
            case 9: {
                this.xor(code, right.type());
                break;
            }
            case 10: {
                this.bitShiftL2(code, left.type());
                break;
            }
            case 11: {
                this.bitShiftR2(code, left.type());
                break;
            }
            case 12: {
                this.bitShiftR3(code, left.type());
                break;
            }
        }
        return start;
    }

    public void bitShiftR2(CodeProxy code, TypeSymbol type) {
        if (type == BasicSymbol.INT) {
            code.append(InstructionConstants.ISHR);
        } else if (type == BasicSymbol.LONG) {
            code.append(InstructionConstants.LSHR);
        } else {
            throw new RuntimeException();
        }
    }

    public void bitShiftL2(CodeProxy code, TypeSymbol type) {
        if (type == BasicSymbol.INT) {
            code.append(InstructionConstants.ISHL);
        } else if (type == BasicSymbol.LONG) {
            code.append(InstructionConstants.LSHL);
        } else {
            throw new RuntimeException();
        }
    }

    public void bitShiftR3(CodeProxy code, TypeSymbol type) {
        if (type == BasicSymbol.INT) {
            code.append(InstructionConstants.IUSHR);
        } else if (type == BasicSymbol.LONG) {
            code.append(InstructionConstants.LUSHR);
        } else {
            throw new RuntimeException();
        }
    }

    public InstructionHandle codeLogicalAnd(BinaryExpressionNode node, CodeProxy code) {
        InstructionHandle start = this.codeExpression(node.getLeft(), code);
        BranchHandle b1 = null;
        BranchHandle b2 = null;
        BranchHandle b3 = null;
        b1 = code.append(new IFEQ(null));
        this.codeExpression(node.getRight(), code);
        b2 = code.append(new IFEQ(null));
        code.append(InstructionConstants.ICONST_1);
        b3 = code.append(new GOTO(null));
        InstructionHandle failure = code.append(InstructionConstants.ICONST_0);
        b1.setTarget(failure);
        b2.setTarget(failure);
        b3.setTarget(code.append(InstructionConstants.NOP));
        return start;
    }

    public InstructionHandle codeLogicalOr(BinaryExpressionNode node, CodeProxy code) {
        InstructionHandle start = this.codeExpression(node.getLeft(), code);
        BranchHandle b1 = null;
        BranchHandle b2 = null;
        BranchHandle b3 = null;
        b1 = code.append(new IFNE(null));
        this.codeExpression(node.getRight(), code);
        b2 = code.append(new IFNE(null));
        code.append(InstructionConstants.ICONST_0);
        b3 = code.append(new GOTO(null));
        InstructionHandle success = code.append(InstructionConstants.ICONST_1);
        b1.setTarget(success);
        b2.setTarget(success);
        b3.setTarget(code.append(new NOP()));
        return start;
    }

    public void bitAnd(CodeProxy code, TypeSymbol type) {
        if (type == BasicSymbol.INT || type == BasicSymbol.BOOLEAN) {
            code.append(new IAND());
        } else if (type == BasicSymbol.LONG) {
            code.append(new LAND());
        } else {
            throw new RuntimeException();
        }
    }

    public void bitOr(CodeProxy code, TypeSymbol type) {
        if (type == BasicSymbol.INT || type == BasicSymbol.BOOLEAN) {
            code.append(new IOR());
        } else if (type == BasicSymbol.LONG) {
            code.append(new LOR());
        } else {
            throw new RuntimeException();
        }
    }

    public void xor(CodeProxy code, TypeSymbol type) {
        if (type == BasicSymbol.INT || type == BasicSymbol.BOOLEAN) {
            code.append(new IXOR());
        } else if (type == BasicSymbol.LONG) {
            code.append(new LXOR());
        } else {
            throw new RuntimeException();
        }
    }

    public void eq(CodeProxy code, TypeSymbol type) {
        BranchHandle b1 = null;
        if (type == BasicSymbol.INT || type == BasicSymbol.CHAR || type == BasicSymbol.BOOLEAN) {
            b1 = code.append(new IF_ICMPEQ(null));
        } else if (type == BasicSymbol.LONG) {
            code.append(new LCMP());
            b1 = code.append(new IFEQ(null));
        } else if (type == BasicSymbol.FLOAT) {
            code.append(new FCMPL());
            b1 = code.append(new IFEQ(null));
        } else if (type == BasicSymbol.DOUBLE) {
            code.append(new DCMPL());
            b1 = code.append(new IFEQ(null));
        } else {
            b1 = code.append(new IF_ACMPEQ(null));
        }
        this.processBranch(code, b1);
    }

    public void noteq(CodeProxy code, TypeSymbol type) {
        BranchHandle b1 = null;
        if (type == BasicSymbol.INT || type == BasicSymbol.CHAR || type == BasicSymbol.BOOLEAN) {
            b1 = code.append(new IF_ICMPNE(null));
        } else if (type == BasicSymbol.LONG) {
            code.append(new LCMP());
            b1 = code.append(new IFNE(null));
        } else if (type == BasicSymbol.FLOAT) {
            code.append(new FCMPL());
            b1 = code.append(new IFNE(null));
        } else if (type == BasicSymbol.DOUBLE) {
            code.append(new DCMPL());
            b1 = code.append(new IFNE(null));
        } else {
            b1 = code.append(new IF_ACMPNE(null));
        }
        this.processBranch(code, b1);
    }

    public void gt(CodeProxy code, TypeSymbol type) {
        BranchHandle b1 = null;
        if (type == BasicSymbol.INT) {
            b1 = code.append(new IF_ICMPGT(null));
        } else if (type == BasicSymbol.LONG) {
            code.append(new LCMP());
            b1 = code.append(new IFGT(null));
        } else if (type == BasicSymbol.FLOAT) {
            code.append(new FCMPL());
            b1 = code.append(new IFGT(null));
        } else if (type == BasicSymbol.DOUBLE) {
            code.append(new DCMPL());
            b1 = code.append(new IFGT(null));
        } else {
            throw new RuntimeException("");
        }
        this.processBranch(code, b1);
    }

    public void gte(CodeProxy code, TypeSymbol type) {
        BranchHandle comparation = null;
        if (type == BasicSymbol.INT) {
            comparation = code.append(new IF_ICMPGE(null));
        } else if (type == BasicSymbol.LONG) {
            code.append(new LCMP());
            comparation = code.append(new IFGE(null));
        } else if (type == BasicSymbol.FLOAT) {
            code.append(new FCMPL());
            comparation = code.append(new IFGE(null));
        } else if (type == BasicSymbol.DOUBLE) {
            code.append(new DCMPL());
            comparation = code.append(new IFGE(null));
        } else {
            throw new RuntimeException("");
        }
        this.processBranch(code, comparation);
    }

    public void lte(CodeProxy code, TypeSymbol type) {
        BranchHandle b1 = null;
        if (type == BasicSymbol.INT) {
            b1 = code.append(new IF_ICMPLE(null));
        } else if (type == BasicSymbol.LONG) {
            code.append(new LCMP());
            b1 = code.append(new IFLT(null));
        } else if (type == BasicSymbol.FLOAT) {
            code.append(new FCMPL());
            b1 = code.append(new IFLE(null));
        } else if (type == BasicSymbol.DOUBLE) {
            code.append(new DCMPL());
            b1 = code.append(new IFLE(null));
        } else {
            throw new RuntimeException("");
        }
        this.processBranch(code, b1);
    }

    public void lt(CodeProxy code, TypeSymbol type) {
        BranchHandle comparation = null;
        if (type == BasicSymbol.INT) {
            comparation = code.append(new IF_ICMPLT(null));
        } else if (type == BasicSymbol.LONG) {
            code.append(new LCMP());
            comparation = code.append(new IFLT(null));
        } else if (type == BasicSymbol.FLOAT) {
            code.append(new FCMPL());
            comparation = code.append(new IFLT(null));
        } else if (type == BasicSymbol.DOUBLE) {
            code.append(new DCMPL());
            comparation = code.append(new IFLT(null));
        } else {
            throw new RuntimeException("");
        }
        this.processBranch(code, comparation);
    }

    private void processBranch(CodeProxy code, BranchHandle b1) {
        code.append(InstructionConstants.ICONST_0);
        BranchHandle b2 = code.append(new GOTO(null));
        b1.setTarget(code.append(InstructionConstants.ICONST_1));
        b2.setTarget(code.append(InstructionConstants.NOP));
    }

    public InstructionHandle codeString(StringNode node, CodeProxy code) {
        return code.appendConstant(node.getValue());
    }

    public InstructionHandle codeInteger(IntegerNode node, CodeProxy code) {
        return code.appendConstant(new Integer(node.getValue()));
    }

    public InstructionHandle codeLong(LongNode node, CodeProxy code) {
        return code.appendConstant(new Long(node.getValue()));
    }

    public InstructionHandle codeFloat(FloatNode node, CodeProxy code) {
        return code.appendConstant(new Float(node.getValue()));
    }

    public InstructionHandle codeDouble(DoubleNode node, CodeProxy code) {
        return code.appendConstant(new Double(node.getValue()));
    }

    public InstructionHandle codeBoolean(BooleanNode node, CodeProxy code) {
        return code.appendConstant(new Boolean(node.getValue()));
    }

    public InstructionHandle codeNull(NullNode node, CodeProxy code) {
        return code.append(InstructionConstants.ACONST_NULL);
    }

    public InstructionHandle codeUnaryExpression(UnaryExpressionNode node, CodeProxy code) {
        InstructionHandle start = this.codeExpression(node.getOperand(), code);
        TypeSymbol type = node.getOperand().type();
        switch (node.getKind()) {
            case 0: {
                this.plus(code, type);
                break;
            }
            case 1: {
                this.minus(code, type);
                break;
            }
            case 2: {
                this.not(code, type);
                break;
            }
            case 3: {
                this.bitNot(code, type);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return start;
    }

    private void plus(CodeProxy code, TypeSymbol type) {
        if (type != BasicSymbol.INT && type != BasicSymbol.LONG && type != BasicSymbol.FLOAT && type != BasicSymbol.DOUBLE) {
            throw new RuntimeException();
        }
    }

    private void minus(CodeProxy code, TypeSymbol type) {
        if (type == BasicSymbol.INT) {
            code.append(InstructionConstants.INEG);
        } else if (type == BasicSymbol.LONG) {
            code.append(InstructionConstants.LNEG);
        } else if (type == BasicSymbol.FLOAT) {
            code.append(InstructionConstants.FNEG);
        } else if (type == BasicSymbol.DOUBLE) {
            code.append(InstructionConstants.DNEG);
        } else {
            throw new RuntimeException();
        }
    }

    private void not(CodeProxy code, TypeSymbol type) {
        if (type != BasicSymbol.BOOLEAN) {
            throw new RuntimeException();
        }
        BranchHandle b1 = code.append(new IFNE(null));
        code.append(new ICONST(1));
        BranchHandle b2 = code.append(new GOTO(null));
        b1.setTarget(code.append(new ICONST(0)));
        b2.setTarget(code.append(new NOP()));
    }

    private void bitNot(CodeProxy code, TypeSymbol type) {
        if (type == BasicSymbol.INT) {
            code.append(new ICONST(-1));
            code.append(new IXOR());
        } else if (type == BasicSymbol.LONG) {
            code.append(new LCONST(-1L));
            code.append(new LXOR());
        } else {
            throw new RuntimeException();
        }
    }

    public InstructionHandle codeCast(CastNode node, CodeProxy code) {
        ExpressionNode target = node.getTarget();
        InstructionHandle start = this.codeExpression(target, code);
        code.appendCast(this.typeOf(target.type()), this.typeOf(node.getConversion()));
        return start;
    }

    public InstructionHandle codeIsInstance(IsInstanceNode node, CodeProxy code) {
        InstructionHandle start = this.codeExpression(node.target, code);
        code.appendInstanceOf((ReferenceType)this.typeOf(node.getCheckType()));
        return start;
    }

    public InstructionHandle codeSelf(SelfNode node, CodeProxy code) {
        return code.append(InstructionConstants.ALOAD_0);
    }

    public InstructionHandle codeFieldRef(FieldRefNode node, CodeProxy code) {
        InstructionHandle start = this.codeExpression(node.target, code);
        ClassSymbol symbol = (ClassSymbol)node.target.type();
        code.appendGetField(symbol.getName(), node.field.getName(), this.typeOf(node.type()));
        return start;
    }

    public InstructionHandle codeFieldAssign(FieldAssignmentNode node, CodeProxy code) {
        InstructionHandle start = this.codeExpression(node.target, code);
        this.codeExpression(node.value, code);
        if (this.isWideType(node.value.type())) {
            code.append(InstructionConstants.DUP2_X1);
        } else {
            code.append(InstructionConstants.DUP_X1);
        }
        ClassSymbol symbol = (ClassSymbol)node.target.type();
        code.appendPutField(symbol.getName(), node.field.getName(), this.typeOf(node.type()));
        return start;
    }

    private void add(CodeProxy code, TypeSymbol type) {
        if (type == BasicSymbol.INT) {
            code.append(new IADD());
        } else if (type == BasicSymbol.LONG) {
            code.append(new LADD());
        } else if (type == BasicSymbol.FLOAT) {
            code.append(new FADD());
        } else {
            code.append(new DADD());
        }
    }

    private void sub(CodeProxy code, TypeSymbol type) {
        if (type == BasicSymbol.INT) {
            code.append(new ISUB());
        } else if (type == BasicSymbol.LONG) {
            code.append(new LSUB());
        } else if (type == BasicSymbol.FLOAT) {
            code.append(new FSUB());
        } else {
            code.append(new DSUB());
        }
    }

    private void mul(CodeProxy code, TypeSymbol type) {
        if (type == BasicSymbol.INT) {
            code.append(new IMUL());
        } else if (type == BasicSymbol.LONG) {
            code.append(new LMUL());
        } else if (type == BasicSymbol.FLOAT) {
            code.append(new FMUL());
        } else {
            code.append(new DMUL());
        }
    }

    private void div(CodeProxy code, TypeSymbol type) {
        if (type == BasicSymbol.INT) {
            code.append(new IDIV());
        } else if (type == BasicSymbol.LONG) {
            code.append(new LDIV());
        } else if (type == BasicSymbol.FLOAT) {
            code.append(new FDIV());
        } else {
            code.append(new DDIV());
        }
    }

    private void mod(CodeProxy code, TypeSymbol type) {
        if (type == BasicSymbol.INT) {
            code.append(new IREM());
        } else if (type == BasicSymbol.LONG) {
            code.append(new LREM());
        } else if (type == BasicSymbol.FLOAT) {
            code.append(new FREM());
        } else {
            code.append(new DREM());
        }
    }

    private int frameObjectIndex(int origin, TypeSymbol[] arguments) {
        int maxIndex = origin;
        for (int i = 0; i < arguments.length; ++i) {
            if (this.isWideType(arguments[i])) {
                maxIndex += 2;
                continue;
            }
            ++maxIndex;
        }
        return maxIndex;
    }

    private int[] indexTableFor(int origin, LocalFrame frame) {
        LocalBinding[] bindings = frame.entries();
        int[] indexTable = new int[bindings.length];
        int maxIndex = origin;
        for (int i = 0; i < bindings.length; ++i) {
            indexTable[i] = maxIndex++;
            if (!this.isWideType(bindings[i].getType())) continue;
            maxIndex += 2;
        }
        return indexTable;
    }

    private int[] indexTableFor(LocalFrame frame) {
        LocalBinding[] bindings = frame.entries();
        int[] indexTable = new int[bindings.length];
        int maxIndex = 0;
        for (int i = 0; i < bindings.length; ++i) {
            indexTable[i] = maxIndex++;
        }
        return indexTable;
    }

    private boolean isWideType(TypeSymbol symbol) {
        return symbol == BasicSymbol.DOUBLE || symbol == BasicSymbol.LONG;
    }

    private Type typeOf(TypeSymbol type) {
        return this.bridge.toVMType(type);
    }

    private Type[] typesOf(TypeSymbol[] types) {
        Type[] destinationTypes = new Type[types.length];
        for (int i = 0; i < destinationTypes.length; ++i) {
            destinationTypes[i] = this.bridge.toVMType(types[i]);
        }
        return destinationTypes;
    }
}

