/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.compiler.phase;

import java.io.IOException;
import java.util.ArrayList;
import org.onion_lang.onion.compiler.CompilationConfiguration;
import org.onion_lang.onion.compiler.problem.CompilationFailureException;
import org.onion_lang.onion.compiler.problem.CompilationProblem;
import org.onion_lang.onion.compiler.utility.Inputs;
import org.onion_lang.onion.compiler.utility.Messages;
import org.onion_lang.onion.lang.syntax.CompilationUnit;
import org.onion_lang.onion.lang.syntax.SourcePosition;
import org.onion_lang.onion.lang.syntax.parser.JavaccOnionParser;
import org.onion_lang.onion.lang.syntax.parser.ParseException;
import org.onion_lang.onion.lang.syntax.parser.Token;

public class ParsingPhase {
    private CompilationConfiguration config;

    public ParsingPhase(CompilationConfiguration config) {
        this.config = config;
    }

    public CompilationUnit[] process(String[] paths) {
        CompilationUnit[] units = new CompilationUnit[paths.length];
        ArrayList<CompilationProblem> problems = new ArrayList<CompilationProblem>();
        for (int i = 0; i < paths.length; ++i) {
            try {
                units[i] = this.parse(paths[i]);
                continue;
            }
            catch (IOException e) {
                problems.add(ParsingPhase.createFileCannotReadProblem(paths[i]));
                continue;
            }
            catch (ParseException e) {
                problems.add(ParsingPhase.createParseFailureProblem(paths[i], e));
            }
        }
        if (problems.size() > 0) {
            throw new CompilationFailureException(problems);
        }
        return units;
    }

    private static CompilationProblem createFileCannotReadProblem(String path) {
        return new CompilationProblem(null, null, Messages.get("error.fileRead", new String[]{path}));
    }

    private static CompilationProblem createParseFailureProblem(String path, ParseException exception) {
        Token errorToken = exception.currentToken.next;
        int line = errorToken.beginLine;
        int column = errorToken.beginColumn;
        return new CompilationProblem(path, new SourcePosition(line, column), Messages.get("error.parsing.syntax", new String[]{exception.getLocalizedMessage()}));
    }

    private static String toString(int value) {
        return Integer.toString(value);
    }

    private CompilationUnit parse(String path) throws IOException, ParseException {
        JavaccOnionParser parser = new JavaccOnionParser(Inputs.newReader(path));
        CompilationUnit unit = parser.CompilationUnit();
        unit.setSourceFileName(path);
        return unit;
    }
}

