/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.compiler.phase.analysis;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.onion_lang.onion.compiler.environment.NameResolution;
import org.onion_lang.onion.compiler.phase.CodeAnalysisPhase;
import org.onion_lang.onion.compiler.problem.SemanticErrorReporter;
import org.onion_lang.onion.lang.kernel.ClassNode;
import org.onion_lang.onion.lang.kernel.ConstructorNode;
import org.onion_lang.onion.lang.kernel.FieldNode;
import org.onion_lang.onion.lang.kernel.MethodNode;
import org.onion_lang.onion.lang.kernel.type.BasicSymbol;
import org.onion_lang.onion.lang.kernel.type.ClassSymbol;
import org.onion_lang.onion.lang.kernel.type.ObjectSymbol;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;
import org.onion_lang.onion.lang.syntax.AbstractSyntaxTreeNode;
import org.onion_lang.onion.lang.syntax.AccessSection;
import org.onion_lang.onion.lang.syntax.ArgumentDeclaration;
import org.onion_lang.onion.lang.syntax.ClassDeclaration;
import org.onion_lang.onion.lang.syntax.CompilationUnit;
import org.onion_lang.onion.lang.syntax.ConstructorDeclaration;
import org.onion_lang.onion.lang.syntax.DelegationDeclaration;
import org.onion_lang.onion.lang.syntax.FieldDeclaration;
import org.onion_lang.onion.lang.syntax.FunctionDeclaration;
import org.onion_lang.onion.lang.syntax.GlobalVariableDeclaration;
import org.onion_lang.onion.lang.syntax.InterfaceDeclaration;
import org.onion_lang.onion.lang.syntax.InterfaceMethodDeclaration;
import org.onion_lang.onion.lang.syntax.MemberDeclaration;
import org.onion_lang.onion.lang.syntax.MethodDeclaration;
import org.onion_lang.onion.lang.syntax.TopLevelElement;
import org.onion_lang.onion.lang.syntax.TypeDeclaration;
import org.onion_lang.onion.lang.syntax.TypeSpecifier;
import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;

public class TypeHeaderAnalysis
extends ASTVisitor
implements SemanticErrorReporter.Constants {
    private CodeAnalysisPhase phase;
    private int countConstructor;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TypeHeaderAnalysis(CodeAnalysisPhase phase) {
        this.phase = phase;
    }

    public void process(CompilationUnit unit) {
        this.phase.setUnit(unit);
        TopLevelElement[] toplevels = unit.getTopLevels();
        for (int i = 0; i < toplevels.length; ++i) {
            this.phase.setCurrentResolver(this.phase.getResolver(this.phase.topClass()));
            this.accept(toplevels[i]);
        }
    }

    public Object visit(ClassDeclaration ast, Object context) {
        this.countConstructor = 0;
        ClassNode node = (ClassNode)this.phase.lookupKernelNode(ast);
        this.phase.setContextClass(node);
        this.phase.setCurrentResolver(this.phase.getResolver(node.getName()));
        this.constructTypeHierarchy(node, new ArrayList());
        if (this.hasCyclicity(node)) {
            this.report(16, ast, new Object[]{node.getName()});
        }
        if (ast.getDefaultSection() != null) {
            this.accept(ast.getDefaultSection());
        }
        AccessSection[] sections = ast.getSections();
        for (int i = 0; i < sections.length; ++i) {
            this.accept(sections[i]);
        }
        if (this.countConstructor == 0) {
            node.addDefaultConstructor();
        }
        return null;
    }

    public Object visit(InterfaceDeclaration ast, Object context) {
        ClassNode node = (ClassNode)this.phase.lookupKernelNode(ast);
        this.phase.setContextClass(node);
        this.phase.setCurrentResolver(this.phase.getResolver(node.getName()));
        this.constructTypeHierarchy(node, new ArrayList());
        if (this.hasCyclicity(node)) {
            this.report(16, ast, new Object[]{node.getName()});
        }
        InterfaceMethodDeclaration[] members = ast.getDeclarations();
        for (int i = 0; i < members.length; ++i) {
            this.accept(members[i], context);
        }
        return null;
    }

    public Object visit(ConstructorDeclaration ast, Object context) {
        ++this.countConstructor;
        TypeSymbol[] args = this.acceptTypes(ast.getArguments());
        ClassNode contextClass = this.phase.getContextClass();
        if (args == null) {
            return null;
        }
        int modifier = ast.getModifier() | this.phase.getAccess();
        ConstructorNode node = new ConstructorNode(modifier, contextClass, args, null, null);
        this.phase.put(ast, node);
        contextClass.addConstructor(node);
        return null;
    }

    public Object visit(DelegationDeclaration ast, Object context) {
        TypeSymbol type = this.phase.resolve(ast.getType());
        if (type == null) {
            return null;
        }
        if (!type.isReferenceType() || !((ObjectSymbol)type).isInterface()) {
            this.report(23, ast.getType(), new Object[]{type});
            return null;
        }
        ClassNode contextClass = this.phase.getContextClass();
        int modifier = ast.getModifier() | this.phase.getAccess() | 0x400;
        String name = ast.getName();
        FieldNode node = new FieldNode(modifier, contextClass, name, type);
        this.phase.put(ast, node);
        contextClass.addField(node);
        return null;
    }

    public Object visit(MethodDeclaration ast, Object context) {
        TypeSymbol[] args = this.acceptTypes(ast.getArguments());
        TypeSymbol returnType = ast.getReturnType() != null ? this.phase.resolve(ast.getReturnType()) : BasicSymbol.VOID;
        if (args == null || returnType == null) {
            return null;
        }
        ClassNode cotextClass = this.phase.getContextClass();
        int modifier = ast.getModifier() | this.phase.getAccess();
        String name = ast.getName();
        MethodNode node = new MethodNode(modifier, cotextClass, name, args, returnType, null);
        this.phase.put(ast, node);
        cotextClass.addMethod(node);
        return null;
    }

    public Object visit(FieldDeclaration ast, Object context) {
        TypeSymbol type = this.phase.resolve(ast.getType());
        if (type == null) {
            return null;
        }
        ClassNode contextClass = this.phase.getContextClass();
        int modifier = ast.getModifier() | this.phase.getAccess();
        String name = ast.getName();
        FieldNode node = new FieldNode(modifier, contextClass, name, type);
        this.phase.put(ast, node);
        contextClass.addField(node);
        return node;
    }

    private TypeSymbol[] acceptTypes(ArgumentDeclaration[] ast) {
        TypeSymbol[] types = new TypeSymbol[ast.length];
        boolean success = true;
        for (int i = 0; i < ast.length; ++i) {
            types[i] = (TypeSymbol)this.accept(ast[i]);
            if (types[i] != null) continue;
            success = false;
        }
        if (success) {
            return types;
        }
        return null;
    }

    public Object visit(ArgumentDeclaration ast, Object context) {
        TypeSymbol type = this.phase.resolve(ast.getType());
        return type;
    }

    private FieldNode createFieldNode(FieldDeclaration ast) {
        TypeSymbol type = this.phase.resolve(ast.getType());
        if (type == null) {
            return null;
        }
        FieldNode node = new FieldNode(ast.getModifier() | this.phase.getAccess(), this.phase.getContextClass(), ast.getName(), type);
        return node;
    }

    public Object visit(InterfaceMethodDeclaration ast, Object context) {
        TypeSymbol[] args = this.acceptTypes(ast.getArguments());
        TypeSymbol returnType = ast.getReturnType() != null ? this.phase.resolve(ast.getReturnType()) : BasicSymbol.VOID;
        if (args == null || returnType == null) {
            return null;
        }
        int modifier = 136;
        ClassNode classType = this.phase.getContextClass();
        String name = ast.getName();
        MethodNode node = new MethodNode(modifier, classType, name, args, returnType, null);
        this.phase.put(ast, node);
        classType.addMethod(node);
        return null;
    }

    public Object visit(FunctionDeclaration ast, Object context) {
        TypeSymbol[] args = this.acceptTypes(ast.getArguments());
        TypeSymbol returnType = ast.getReturnType() != null ? this.phase.resolve(ast.getReturnType()) : BasicSymbol.VOID;
        if (args == null || returnType == null) {
            return null;
        }
        ClassNode classType = (ClassNode)this.phase.loadTopClass();
        int modifier = ast.getModifier() | 0x80;
        String name = ast.getName();
        MethodNode node = new MethodNode(modifier, classType, name, args, returnType, null);
        this.phase.put(ast, node);
        classType.addMethod(node);
        return null;
    }

    public Object visit(GlobalVariableDeclaration ast, Object context) {
        TypeSymbol type = this.phase.resolve(ast.getType());
        if (type == null) {
            return null;
        }
        int modifier = ast.getModifier() | 0x80;
        ClassNode classType = (ClassNode)this.phase.loadTopClass();
        String name = ast.getName();
        FieldNode node = new FieldNode(modifier, classType, name, type);
        this.phase.put(ast, node);
        classType.addField(node);
        return null;
    }

    public Object visit(AccessSection section, Object context) {
        if (section == null) {
            return null;
        }
        this.phase.setAccess(section.getID());
        MemberDeclaration[] members = section.getMembers();
        for (int i = 0; i < members.length; ++i) {
            this.accept(members[i], context);
        }
        return null;
    }

    public boolean hasCyclicity(ClassNode start) {
        return this.hasCylicitySub(start, new HashSet());
    }

    private boolean hasCylicitySub(ClassSymbol symbol, HashSet visit) {
        if (symbol == null) {
            return false;
        }
        if (visit.contains(symbol)) {
            return true;
        }
        visit.add(symbol);
        if (this.hasCylicitySub(symbol.getSuperClass(), (HashSet)visit.clone())) {
            return true;
        }
        ClassSymbol[] interfaces = symbol.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!this.hasCylicitySub(interfaces[i], (HashSet)visit.clone())) continue;
            return true;
        }
        return false;
    }

    private void constructTypeHierarchy(ClassSymbol symbol, List visit) {
        if (symbol == null || visit.indexOf(symbol) >= 0) {
            return;
        }
        visit.add(symbol);
        if (symbol instanceof ClassNode) {
            ClassSymbol superType;
            int i;
            TypeSpecifier[] typeSpecifiers;
            TypeDeclaration ast;
            ClassNode node = (ClassNode)symbol;
            if (node.isResolutionComplete()) {
                return;
            }
            ClassSymbol superClass = null;
            ArrayList<ClassSymbol> interfaces = new ArrayList<ClassSymbol>();
            NameResolution resolver = this.phase.getResolver(node.getName());
            if (node.isInterface()) {
                ast = (InterfaceDeclaration)this.phase.lookupAST(node);
                superClass = this.phase.rootClass();
                typeSpecifiers = ((InterfaceDeclaration)ast).getInterfaces();
                for (i = 0; i < typeSpecifiers.length; ++i) {
                    superType = this.validateSuperType(typeSpecifiers[i], true, resolver);
                    if (superType == null) continue;
                    interfaces.add(superType);
                }
            } else {
                ast = (ClassDeclaration)this.phase.lookupAST(node);
                superClass = this.validateSuperType(((ClassDeclaration)ast).getSuperClass(), false, resolver);
                typeSpecifiers = ((ClassDeclaration)ast).getInterfaces();
                for (i = 0; i < typeSpecifiers.length; ++i) {
                    superType = this.validateSuperType(typeSpecifiers[i], true, resolver);
                    if (superType == null) continue;
                    interfaces.add(superType);
                }
            }
            this.constructTypeHierarchy(superClass, visit);
            Iterator i2 = interfaces.iterator();
            while (i2.hasNext()) {
                ClassSymbol superType2 = (ClassSymbol)i2.next();
                this.constructTypeHierarchy(superType2, visit);
            }
            node.setSuperClass(superClass);
            node.setInterfaces(interfaces.toArray(new ClassSymbol[0]));
            node.setResolutionComplete(true);
        } else {
            this.constructTypeHierarchy(symbol.getSuperClass(), visit);
            ClassSymbol[] interfaces = symbol.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                this.constructTypeHierarchy(interfaces[i], visit);
            }
        }
    }

    private ClassSymbol validateSuperType(TypeSpecifier ast, boolean shouldInterface, NameResolution resolver) {
        if (!$assertionsDisabled && ast.getDimension() != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && ast.getComponentKind() == 0) {
            throw new AssertionError();
        }
        ClassSymbol symbol = null;
        symbol = ast == null ? this.phase.table().rootClass() : (ClassSymbol)this.phase.resolve(ast, resolver);
        if (symbol == null) {
            return null;
        }
        boolean isInterface = symbol.isInterface();
        if (!isInterface && shouldInterface || isInterface && !shouldInterface) {
            AbstractSyntaxTreeNode astNode = null;
            if (symbol instanceof ClassNode) {
                astNode = this.phase.lookupAST((ClassNode)symbol);
            }
            this.report(18, astNode, new Object[]{symbol.getName()});
        }
        return symbol;
    }

    private void report(int error, AbstractSyntaxTreeNode ast, Object[] items) {
        this.phase.report(error, ast, items);
    }

    static {
        $assertionsDisabled = !TypeHeaderAnalysis.class.desiredAssertionStatus();
    }
}

