/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.compiler.problem;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.onion_lang.onion.compiler.problem.CompilationFailureException;
import org.onion_lang.onion.compiler.problem.CompilationProblem;
import org.onion_lang.onion.compiler.utility.Messages;
import org.onion_lang.onion.lang.kernel.type.ClassSymbol;
import org.onion_lang.onion.lang.kernel.type.ObjectSymbol;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;
import org.onion_lang.onion.lang.syntax.SourcePosition;

public class SemanticErrorReporter {
    private List problems;
    private String currentSourceFile;
    int errorCount;
    int threshold;

    public SemanticErrorReporter(int threshold) {
        this.threshold = threshold;
        this.problems = new ArrayList();
    }

    private String format(String string, String arg) {
        return MessageFormat.format(string, arg);
    }

    private String format(String string, String arg1, String arg2) {
        return MessageFormat.format(string, arg1, arg2);
    }

    private String format(String string, String arg1, String arg2, String arg3) {
        return MessageFormat.format(string, arg1, arg2, arg3);
    }

    private String format(String string, String arg1, String arg2, String arg3, String arg4) {
        return MessageFormat.format(string, arg1, arg2, arg3, arg4);
    }

    private String format(String string, String[] args) {
        return MessageFormat.format(string, args);
    }

    private String message(String property) {
        return Messages.get(property);
    }

    private void reportIncompatibleType(SourcePosition position, Object[] items) {
        TypeSymbol expected = (TypeSymbol)items[0];
        TypeSymbol detected = (TypeSymbol)items[1];
        this.problem(position, this.format(this.message("error.semantic.incompatibleType"), expected.getName(), detected.getName()));
    }

    private String names(TypeSymbol[] types) {
        StringBuffer buffer = new StringBuffer();
        if (types.length > 0) {
            buffer.append(types[0].getName());
            for (int i = 1; i < types.length; ++i) {
                buffer.append(", ");
                buffer.append(types[i].getName());
            }
        }
        return new String(buffer);
    }

    private void reportIncompatibleOperandType(SourcePosition position, Object[] items) {
        String operator = (String)items[0];
        TypeSymbol[] operands = (TypeSymbol[])items[1];
        this.problem(position, this.format(this.message("error.semantic.incompatibleOperandType"), (String)items[0], this.names(operands)));
    }

    private void reportVariableNotFound(SourcePosition position, Object[] items) {
        this.problem(position, this.format(this.message("error.semantic.variableNotFound"), (String)items[0]));
    }

    private void reportClassNotFound(SourcePosition position, Object[] items) {
        this.problem(position, this.format(this.message("error.semantic.classNotFound"), (String)items[0]));
    }

    private void reportFieldNotFound(SourcePosition position, Object[] items) {
        this.problem(position, this.format(this.message("error.semantic.fieldNotFound"), ((TypeSymbol)items[0]).getName(), (String)items[1]));
    }

    private void reportMethodNotFound(SourcePosition position, Object[] items) {
        this.problem(position, this.format(this.message("error.semantic.methodNotFound"), ((TypeSymbol)items[0]).getName(), (String)items[1], this.names((TypeSymbol[])items[2])));
    }

    private void reportAmbiguousMethod(SourcePosition position, Object[] items) {
        Object[] item1 = (Object[])items[0];
        Object[] item2 = (Object[])items[1];
        String target1 = ((ObjectSymbol)item1[0]).getName();
        String name1 = (String)item1[1];
        String args1 = this.names((TypeSymbol[])item1[2]);
        String target2 = ((ObjectSymbol)item2[0]).getName();
        String name2 = (String)item2[1];
        String args2 = this.names((TypeSymbol[])item2[2]);
        this.problem(position, this.format(this.message("error.semantic.ambiguousMethod"), new String[]{target1, name1, args2, target2, name2, args2}));
    }

    private void reportDuplicateLocalVariable(SourcePosition position, Object[] items) {
        this.problem(position, this.format(this.message("error.semantic.duplicatedVariable"), (String)items[0]));
    }

    private void reportDuplicateClass(SourcePosition position, Object[] items) {
        this.problem(position, this.format(this.message("error.semantic.duplicatedClass"), (String)items[0]));
    }

    private void reportDuplicateField(SourcePosition position, Object[] items) {
        this.problem(position, this.format(this.message("error.semantic.duplicatedField"), ((TypeSymbol)items[0]).getName(), (String)items[1]));
    }

    private void reportDuplicateMethod(SourcePosition position, Object[] items) {
        this.problem(position, this.format(this.message("error.semantic.duplicatedMethod"), ((TypeSymbol)items[0]).getName(), (String)items[1], this.names((TypeSymbol[])items[2])));
    }

    private void reportDuplicateGlobalVariable(SourcePosition position, Object[] items) {
        this.problem(position, this.format(this.message("error.semantic.duplicatedGlobalVariable"), (String)items[0]));
    }

    private void reportDuplicateFunction(SourcePosition position, Object[] items) {
        this.problem(position, this.format(this.message("error.semantic.duplicatedGlobalVariable"), (String)items[0], this.names((TypeSymbol[])items[1])));
    }

    private void reportDuplicateConstructor(SourcePosition position, Object[] items) {
        this.problem(position, this.format(this.message("error.semantic.duplicatedConstructor"), ((TypeSymbol)items[0]).getName(), this.names((TypeSymbol[])items[1])));
    }

    private void reportMethodNotAccessible(SourcePosition position, Object[] items) {
        this.problem(position, this.format(this.message("error.semantic.methodNotAccessible"), ((ObjectSymbol)items[0]).getName(), (String)items[1], this.names((TypeSymbol[])items[2]), ((ClassSymbol)items[3]).getName()));
    }

    private void reportFieldNotAccessible(SourcePosition position, Object[] items) {
        this.problem(position, this.format(this.message("error.semantic.fieldNotAccessible"), ((ClassSymbol)items[0]).getName(), (String)items[1], ((ClassSymbol)items[2]).getName()));
    }

    private void reportClassNotAccessible(SourcePosition position, Object[] items) {
        this.problem(position, this.format(this.message("error.semantic.classNotAccessible"), ((ClassSymbol)items[0]).getName(), ((ClassSymbol)items[1]).getName()));
    }

    private void reportCyclicInheritance(SourcePosition position, Object[] items) {
        this.problem(position, this.format(this.message("error.semantic.cyclicInheritance"), (String)items[0]));
    }

    private void reportCyclicDelegation(SourcePosition position, Object[] items) {
        this.problem(position, this.message("error.semantic.cyclicDelegation"));
    }

    private void reportIllegalInheritance(SourcePosition position, Object[] items) {
    }

    private void reportCannotReturnValue(SourcePosition position, Object[] items) {
        this.problem(position, this.message("error.semantic.cannotReturnValue"));
    }

    private void reportConstructorNotFound(SourcePosition position, Object[] items) {
        String type = ((TypeSymbol)items[0]).getName();
        String args = this.names((TypeSymbol[])items[1]);
        this.problem(position, this.format(this.message("error.semantic.constructorNotFound"), type, args));
    }

    private void reportAmbiguousConstructor(SourcePosition position, Object[] items) {
        Object[] item1 = (Object[])items[0];
        Object[] item2 = (Object[])items[1];
        String target1 = ((ObjectSymbol)item1[0]).getName();
        String args1 = this.names((TypeSymbol[])item1[1]);
        String target2 = ((ObjectSymbol)item2[0]).getName();
        String args2 = this.names((TypeSymbol[])item2[1]);
        this.problem(position, this.format(this.message("error.semantic.ambiguousMethod"), target1, args2, target2, args2));
    }

    private void reportInterfaceRequied(SourcePosition position, Object[] items) {
        TypeSymbol type = (TypeSymbol)items[0];
        this.problem(position, this.format(this.message("error.semantic.interfaceRequired"), type.getName()));
    }

    private void reportUnimplementedFeature(SourcePosition position, Object[] items) {
        this.problem(position, this.message("error.semantic.unimplementedFeature"));
    }

    private void reportDuplicateGeneratedMethod(SourcePosition position, Object[] items) {
        this.problem(position, this.format(this.message("error.semantic.duplicateGeneratedMethod"), ((TypeSymbol)items[0]).getName(), (String)items[1], this.names((TypeSymbol[])items[2])));
    }

    private void problem(SourcePosition position, String message) {
        this.problems.add(new CompilationProblem(this.currentSourceFile, position, message));
    }

    public void report(int error, SourcePosition position, Object[] items) {
        ++this.errorCount;
        switch (error) {
            case 0: {
                this.reportIncompatibleType(position, items);
                break;
            }
            case 1: {
                this.reportIncompatibleOperandType(position, items);
                break;
            }
            case 2: {
                this.reportVariableNotFound(position, items);
                break;
            }
            case 3: {
                this.reportClassNotFound(position, items);
                break;
            }
            case 4: {
                this.reportFieldNotFound(position, items);
                break;
            }
            case 5: {
                this.reportMethodNotFound(position, items);
                break;
            }
            case 6: {
                this.reportAmbiguousMethod(position, items);
                break;
            }
            case 7: {
                this.reportDuplicateLocalVariable(position, items);
                break;
            }
            case 8: {
                this.reportDuplicateClass(position, items);
                break;
            }
            case 9: {
                this.reportDuplicateField(position, items);
                break;
            }
            case 10: {
                this.reportDuplicateMethod(position, items);
                break;
            }
            case 11: {
                this.reportDuplicateGlobalVariable(position, items);
                break;
            }
            case 12: {
                this.reportDuplicateFunction(position, items);
                break;
            }
            case 13: {
                this.reportMethodNotAccessible(position, items);
                break;
            }
            case 14: {
                this.reportFieldNotAccessible(position, items);
                break;
            }
            case 15: {
                this.reportClassNotAccessible(position, items);
                break;
            }
            case 16: {
                this.reportCyclicInheritance(position, items);
                break;
            }
            case 17: {
                this.reportCyclicDelegation(position, items);
                break;
            }
            case 18: {
                this.reportIllegalInheritance(position, items);
                break;
            }
            case 20: {
                this.reportCannotReturnValue(position, items);
                break;
            }
            case 21: {
                this.reportConstructorNotFound(position, items);
                break;
            }
            case 22: {
                this.reportAmbiguousConstructor(position, items);
                break;
            }
            case 23: {
                this.reportInterfaceRequied(position, items);
                break;
            }
            case 24: {
                this.reportUnimplementedFeature(position, items);
                break;
            }
            case 25: {
                this.reportDuplicateConstructor(position, items);
                break;
            }
            case 26: {
                this.reportDuplicateGeneratedMethod(position, items);
            }
        }
        if (this.errorCount > this.threshold) {
            throw new CompilationFailureException(this.problems);
        }
    }

    public CompilationProblem[] getProblems() {
        return this.problems.toArray(new CompilationProblem[0]);
    }

    public void setCurrentSourceFile(String currentSourceFile) {
        this.currentSourceFile = currentSourceFile;
    }

    public static interface Constants {
        public static final int INCOMPATIBLE_TYPE = 0;
        public static final int INCOMPATIBLE_OPERAND_TYPE = 1;
        public static final int VARIABLE_NOT_FOUND = 2;
        public static final int CLASS_NOT_FOUND = 3;
        public static final int FIELD_NOT_FOUND = 4;
        public static final int METHOD_NOT_FOUND = 5;
        public static final int AMBIGUOUS_METHOD = 6;
        public static final int DUPLICATE_LOCAL_VARIABLE = 7;
        public static final int DUPLICATE_CLASS = 8;
        public static final int DUPLICATE_FIELD = 9;
        public static final int DUPLICATE_METHOD = 10;
        public static final int DUPLICATE_GLOBAL_VARIABLE = 11;
        public static final int DUPLICATE_FUNCTION = 12;
        public static final int METHOD_NOT_ACCESSIBLE = 13;
        public static final int FIELD_NOT_ACCESSIBLE = 14;
        public static final int CLASS_NOT_ACCESSIBLE = 15;
        public static final int CYCLIC_INHERITANCE = 16;
        public static final int CYCLIC_DELEGATION = 17;
        public static final int ILLEGAL_INHERITANCE = 18;
        public static final int ILLEGAL_METHOD_CALL = 19;
        public static final int CANNOT_RETURN_VALUE = 20;
        public static final int CONSTRUCTOR_NOT_FOUND = 21;
        public static final int AMBIGUOUS_CONSTRUCTOR = 22;
        public static final int INTERFACE_REQUIRED = 23;
        public static final int UNIMPLEMENTED_FEATURE = 24;
        public static final int DUPLICATE_CONSTRUCTOR = 25;
        public static final int DUPLICATE_GENERATED_METHOD = 26;
    }
}

