/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.compiler.utility;

import org.onion_lang.onion.compiler.environment.ClassTable;
import org.onion_lang.onion.lang.kernel.ExpressionNode;
import org.onion_lang.onion.lang.kernel.NewNode;
import org.onion_lang.onion.lang.kernel.type.BasicSymbol;
import org.onion_lang.onion.lang.kernel.type.ClassSymbol;
import org.onion_lang.onion.lang.kernel.type.ConstructorSymbol;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

public class Boxing {
    private Boxing() {
    }

    public static ExpressionNode boxing(ClassTable table, ExpressionNode node) {
        ClassSymbol boxedType;
        BasicSymbol type = (BasicSymbol)node.type();
        if (type == BasicSymbol.BOOLEAN) {
            boxedType = table.load("java.lang.Boolean");
        } else if (type == BasicSymbol.BYTE) {
            boxedType = table.load("java.lang.Byte");
        } else if (type == BasicSymbol.SHORT) {
            boxedType = table.load("java.lang.Short");
        } else if (type == BasicSymbol.CHAR) {
            boxedType = table.load("java.lang.Character");
        } else if (type == BasicSymbol.INT) {
            boxedType = table.load("java.lang.Integer");
        } else if (type == BasicSymbol.LONG) {
            boxedType = table.load("java.lang.Long");
        } else if (type == BasicSymbol.FLOAT) {
            boxedType = table.load("java.lang.Float");
        } else if (type == BasicSymbol.DOUBLE) {
            boxedType = table.load("java.lang.Double");
        } else {
            return null;
        }
        ConstructorSymbol[] cs = boxedType.getConstructors();
        for (int i = 0; i < cs.length; ++i) {
            TypeSymbol[] args = cs[i].getArguments();
            if (args.length != 1 || args[i] != type) continue;
            return new NewNode(cs[i], new ExpressionNode[]{node});
        }
        return null;
    }
}

