/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.lang.kernel.type;

import org.onion_lang.onion.compiler.environment.ClassTable;
import org.onion_lang.onion.compiler.utility.Strings;
import org.onion_lang.onion.lang.kernel.type.ClassSymbol;
import org.onion_lang.onion.lang.kernel.type.FieldSymbol;
import org.onion_lang.onion.lang.kernel.type.MethodSymbol;
import org.onion_lang.onion.lang.kernel.type.ObjectSymbol;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

public class ArraySymbol
implements ObjectSymbol {
    private ClassTable table;
    private TypeSymbol component;
    private int dimension;
    private ClassSymbol superClass;
    private ClassSymbol[] interfaces;
    private String name;

    public ArraySymbol(TypeSymbol component, int dimension, ClassTable table) {
        this.component = component;
        this.dimension = dimension;
        this.superClass = table.load("java.lang.Object");
        this.interfaces = new ClassSymbol[]{table.load("java.io.Serializable"), table.load("java.lang.Cloneable")};
        this.name = Strings.repeat("[", dimension) + component.getName();
    }

    public TypeSymbol getComponent() {
        return this.component;
    }

    public TypeSymbol getBase() {
        if (this.dimension == 1) {
            return this.component;
        }
        return this.table.loadArray(this.component, this.dimension - 1);
    }

    public int getDimension() {
        return this.dimension;
    }

    public boolean isInterface() {
        return false;
    }

    public int getModifier() {
        return 0;
    }

    public ClassSymbol getSuperClass() {
        return this.superClass;
    }

    public ClassSymbol[] getInterfaces() {
        return this.interfaces;
    }

    public MethodSymbol[] getMethods() {
        return this.superClass.getMethods();
    }

    public FieldSymbol[] getFields() {
        return this.superClass.getFields();
    }

    public String getName() {
        return this.name;
    }

    public boolean isArrayType() {
        return true;
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isClassType() {
        return false;
    }

    public boolean isNullType() {
        return false;
    }

    public boolean isReferenceType() {
        return true;
    }
}

