/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.lang.kernel.type;

import org.onion_lang.onion.lang.kernel.type.ArraySymbol;
import org.onion_lang.onion.lang.kernel.type.BasicSymbol;
import org.onion_lang.onion.lang.kernel.type.ClassSymbol;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

public class TypeRules {
    private TypeRules() {
    }

    public static boolean isSuperType(TypeSymbol left, TypeSymbol right) {
        if (left.isBasicType()) {
            if (right.isBasicType()) {
                return TypeRules.isSuperTypeForBasic((BasicSymbol)left, (BasicSymbol)right);
            }
            return false;
        }
        if (left.isClassType()) {
            if (right.isClassType()) {
                return TypeRules.isSuperTypeForClass((ClassSymbol)left, (ClassSymbol)right);
            }
            if (right.isArrayType()) {
                return left == ((ArraySymbol)right).getSuperClass();
            }
            return right.isNullType();
        }
        if (left.isArrayType()) {
            if (right.isArrayType()) {
                return TypeRules.isSuperTypeForArray((ArraySymbol)left, (ArraySymbol)right);
            }
            return right.isNullType();
        }
        return false;
    }

    public static boolean isAssignable(TypeSymbol left, TypeSymbol right) {
        return TypeRules.isSuperType(left, right) || TypeRules.isSuperType(right, left);
    }

    private static boolean isSuperTypeForArray(ArraySymbol left, ArraySymbol right) {
        return TypeRules.isSuperType(left.getBase(), right.getBase());
    }

    private static boolean isSuperTypeForClass(ClassSymbol left, ClassSymbol right) {
        if (right == null) {
            return false;
        }
        if (left == right) {
            return true;
        }
        if (TypeRules.isSuperTypeForClass(left, right.getSuperClass())) {
            return true;
        }
        for (int i = 0; i < right.getInterfaces().length; ++i) {
            if (!TypeRules.isSuperTypeForClass(left, right.getInterfaces()[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean isSuperTypeForBasic(BasicSymbol left, BasicSymbol right) {
        if (left == BasicSymbol.DOUBLE) {
            return right == BasicSymbol.CHAR || right == BasicSymbol.BYTE || right == BasicSymbol.SHORT || right == BasicSymbol.INT || right == BasicSymbol.LONG || right == BasicSymbol.FLOAT || right == BasicSymbol.DOUBLE;
        }
        if (left == BasicSymbol.FLOAT) {
            return right == BasicSymbol.CHAR || right == BasicSymbol.BYTE || right == BasicSymbol.SHORT || right == BasicSymbol.INT || right == BasicSymbol.LONG || right == BasicSymbol.FLOAT;
        }
        if (left == BasicSymbol.LONG) {
            return right == BasicSymbol.CHAR || right == BasicSymbol.BYTE || right == BasicSymbol.SHORT || right == BasicSymbol.INT || right == BasicSymbol.LONG;
        }
        if (left == BasicSymbol.INT) {
            return right == BasicSymbol.CHAR || right == BasicSymbol.BYTE || right == BasicSymbol.SHORT || right == BasicSymbol.INT;
        }
        if (left == BasicSymbol.SHORT) {
            return right == BasicSymbol.BYTE || right == BasicSymbol.SHORT;
        }
        if (left == BasicSymbol.BOOLEAN && right == BasicSymbol.BOOLEAN) {
            return true;
        }
        return left == BasicSymbol.BYTE && right == BasicSymbol.BYTE;
    }
}

