/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.onion_lang.onion.tools.OptionConfiguration;
import org.onion_lang.onion.tools.ParseFailure;
import org.onion_lang.onion.tools.ParseResult;
import org.onion_lang.onion.tools.ParseSuccess;

public class CommandLineParser {
    private final OptionConfiguration[] configurations;

    public CommandLineParser(OptionConfiguration[] configurations) {
        this.configurations = configurations;
    }

    private static boolean isOptionName(String name) {
        return name.startsWith("-");
    }

    public ParseResult parse(String[] commandLine) {
        HashMap noArgumentOptions = new HashMap();
        HashMap options = new HashMap();
        ArrayList arguments = new ArrayList();
        ArrayList lackedOptions = new ArrayList();
        ArrayList invalidOptions = new ArrayList();
        for (int i = 0; i < commandLine.length; i += this.checkArgument(commandLine, i, noArgumentOptions, options, arguments, lackedOptions, invalidOptions)) {
        }
        if (lackedOptions.size() == 0 && invalidOptions.size() == 0) {
            return new ParseSuccess(noArgumentOptions, options, arguments);
        }
        return new ParseFailure(lackedOptions.toArray(new String[0]), invalidOptions.toArray(new String[0]));
    }

    private OptionConfiguration getConfiguration(String optionName) {
        for (int i = 0; i < this.configurations.length; ++i) {
            if (!this.configurations[i].getOptionName().equals(optionName)) continue;
            return this.configurations[i];
        }
        return null;
    }

    private int checkArgument(String[] commandLine, int index, Map noArgumentOptions, Map options, List arguments, List lackedOptions, List invalidOptions) {
        String param = commandLine[index];
        if (CommandLineParser.isOptionName(param)) {
            OptionConfiguration configuration = this.getConfiguration(param);
            if (configuration == null) {
                invalidOptions.add(param);
                return 1;
            }
            if (configuration.requireArgument()) {
                if (index + 1 >= commandLine.length) {
                    lackedOptions.add(param);
                } else {
                    options.put(param, commandLine[index + 1]);
                }
                return 2;
            }
            noArgumentOptions.put(param, new Object());
            return 1;
        }
        arguments.add(param);
        return 1;
    }
}

