/*
 * Decompiled with CFR 0.152.
 */
package org.onion_lang.onion.tools;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import org.onion_lang.onion.compiler.CompilationConfiguration;
import org.onion_lang.onion.compiler.CompiledClass;
import org.onion_lang.onion.compiler.OnionCompiler;
import org.onion_lang.onion.compiler.utility.Messages;
import org.onion_lang.onion.compiler.utility.Systems;
import org.onion_lang.onion.tools.CommandLineParser;
import org.onion_lang.onion.tools.OptionConfiguration;
import org.onion_lang.onion.tools.ParseFailure;
import org.onion_lang.onion.tools.ParseResult;
import org.onion_lang.onion.tools.ParseSuccess;

public class OnionCompilerFrontend {
    private CommandLineParser commandLineParser = new CommandLineParser(new OptionConfiguration[]{OnionCompilerFrontend.conf("-classpath", true), OnionCompilerFrontend.conf("-sourcepath", true), OnionCompilerFrontend.conf("-encoding", true), OnionCompilerFrontend.conf("-d", true)});

    private static String message(String key) {
        return Messages.get(key);
    }

    private static String format(String template, String parameter) {
        return MessageFormat.format(template, parameter);
    }

    private static OptionConfiguration conf(String optionName, boolean requireArgument) {
        return new OptionConfiguration(optionName, requireArgument);
    }

    public int run(String[] commandLine) {
        ParseSuccess result = this.parseCommandLine(commandLine);
        if (result == null) {
            return -1;
        }
        CompiledClass[] binaries = this.startCompile(result);
        if (binaries == null) {
            return -1;
        }
        boolean generated = this.generateFile(binaries);
        if (!generated) {
            return -1;
        }
        return 0;
    }

    private String getSimpleName(String fqcn) {
        int index = fqcn.lastIndexOf(".");
        if (index < 0) {
            return fqcn;
        }
        return fqcn.substring(index + 1, fqcn.length());
    }

    public String getOutputPath(String outDir, String fqcn) {
        String name = this.getSimpleName(fqcn);
        return outDir + Systems.getFileSeparator() + name + ".class";
    }

    private boolean generateFile(CompiledClass[] binaries) {
        for (int i = 0; i < binaries.length; ++i) {
            CompiledClass binary = binaries[i];
            String outDir = binary.getOutputPath();
            new File(outDir).mkdirs();
            String outPath = this.getOutputPath(outDir, binary.getClassName());
            File targetFile = new File(outPath);
            try {
                if (!targetFile.exists()) {
                    targetFile.createNewFile();
                }
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(targetFile));
                out.write(binary.getContent());
                out.close();
                continue;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private ParseSuccess parseCommandLine(String[] commandLine) {
        ParseResult result = this.commandLineParser.parse(commandLine);
        if (result.getStatus() == 1) {
            int i;
            ParseFailure failure = (ParseFailure)result;
            String[] lackedOptions = failure.getLackedOptions();
            String[] invalidOptions = failure.getInvalidOptions();
            for (i = 0; i < invalidOptions.length; ++i) {
                System.err.println(OnionCompilerFrontend.format(OnionCompilerFrontend.message("option.invalidArgument"), invalidOptions[i]));
            }
            for (i = 0; i < lackedOptions.length; ++i) {
                System.err.println(OnionCompilerFrontend.format(OnionCompilerFrontend.message("option.noArgument"), lackedOptions[i]));
            }
            return null;
        }
        return (ParseSuccess)result;
    }

    private CompiledClass[] startCompile(ParseSuccess success) {
        String[] stringArray;
        String[] stringArray2;
        Map option = success.getOptions();
        String sourcepath = (String)option.get("-sourcepath");
        String classpath = (String)option.get("-classpath");
        String encoding = (String)option.get("-encoding");
        String outputDirectory = (String)option.get("-d");
        String[] fileNames = success.getArguments().toArray(new String[0]);
        if (sourcepath != null) {
            stringArray2 = OnionCompilerFrontend.pathArray(sourcepath);
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = ".";
        }
        if (classpath != null) {
            stringArray = OnionCompilerFrontend.pathArray(classpath);
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = ".";
        }
        OnionCompiler compiler = new OnionCompiler(new CompilationConfiguration(stringArray2, stringArray, encoding != null ? encoding : "Shift_JIS", outputDirectory != null ? outputDirectory : ".", 1));
        return compiler.compile(fileNames);
    }

    private static String[] pathArray(String path) {
        return path.split(Systems.getPathSeparator());
    }

    public static void main(String[] args) throws Exception {
        new OnionCompilerFrontend().run(args);
    }
}

