/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.compiler;

import org.onion_lang.onion.compiler.utility.ArrayUtil;

/**
 * @author Kota Mizushima
 * Date: 2005/04/08
 */
public class CompilerConfig implements Cloneable {
  private final String[] classPath;
  private final String encoding;
  private final String outputDirectory;
  private final int maxErrorReports;

  public CompilerConfig(
    String[] classPath, String encoding, 
    String outputDirectory, int maxErrorReports
  ) {
    this.classPath = (String[]) classPath.clone();
    this.encoding = encoding;
    this.outputDirectory = outputDirectory;
    this.maxErrorReports = maxErrorReports;
  }
  
  public Object clone(){
    return new CompilerConfig(
      (String[])classPath.clone(),
      encoding,
      outputDirectory,
      maxErrorReports
    );
  }
  
  
  public String[] getClassPath(){
    return (String[])classPath.clone();
  }
  
  public String getEncoding(){
    return encoding;
  }
  
  public String getOutputDirectory(){
    return outputDirectory;
  }
  
  public int getMaxErrorReports(){
    return maxErrorReports;
  }
  
  public boolean equals(Object object){
    CompilerConfig another = (CompilerConfig) object;
    return 
    			encoding.equals(another.encoding)
    	&&	ArrayUtil.equals(classPath, another.classPath)
    	&&	outputDirectory.equals(another.outputDirectory)
    	&&	maxErrorReports == another.maxErrorReports;
  }
}
