/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.compiler;

import java.util.HashMap;
import java.util.Map;

import org.apache.bcel.generic.*;
import org.onion_lang.onion.lang.kernel.type.*;

/**
 * @author Kota Mizushima
 * Date: 2005/06/28
 */
public class VMTypeBridge {
  private static Map basicTypeTable = new HashMap(){{
    put(BasicSymbol.BYTE,			BasicType.BYTE);
    put(BasicSymbol.SHORT,		BasicType.SHORT);
    put(BasicSymbol.CHAR,			BasicType.CHAR);
    put(BasicSymbol.INT,			BasicType.INT);
    put(BasicSymbol.LONG, 		BasicType.LONG);
    put(BasicSymbol.FLOAT,		BasicType.FLOAT);
    put(BasicSymbol.DOUBLE, 	BasicType.DOUBLE);
    put(BasicSymbol.BOOLEAN,	BasicType.BOOLEAN);
    put(BasicSymbol.VOID,			BasicType.VOID);
  }};
  
  public VMTypeBridge() {
  }

  public Type toVMType(TypeSymbol type){
    if(type.isBasicType()){
      return (BasicType) basicTypeTable.get(type);
    }else if(type.isArrayType()){
      ArraySymbol arrayType = (ArraySymbol)type;
      return new ArrayType(
        toVMType(arrayType.getComponent()), arrayType.getDimension());
    }else if(type.isClassType()){
      return new ObjectType(((ClassSymbol)type).getName());
    }else{
      return Type.NULL;
    }
  }
}
