/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.compiler.problem;

import java.util.List;

import org.onion_lang.onion.lang.syntax.SourcePosition;

/**
 * @author Kota Mizushima
 */
public class CompilationFailureException extends RuntimeException{    
  private List problems;

  public CompilationFailureException(List problems) {
    this.problems = problems;
  }
  
  public CompilationProblem getProblem(int index){
    return (CompilationProblem)problems.get(index);
  }
  
  public int getSizeOfProblems(){
    return problems.size();
  }
}
