/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.kernel;

import org.onion_lang.onion.lang.kernel.type.ArraySymbol;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

/**
 * @author Kota Mizushima
 * Date: 2005/06/21
 */
public class ArrayRefNode extends ExpressionNode {
  private final ExpressionNode object, index;

  public ArrayRefNode(ExpressionNode target, ExpressionNode index) {
    this.object = target;
    this.index = index;
  }

  public ExpressionNode getIndex() {
    return index;
  }
  
  public ExpressionNode getObject() {
    return object;
  }
  
  public TypeSymbol type(){
    return ((ArraySymbol)object.type()).getBase();
  }
}