/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.kernel;

import org.onion_lang.onion.compiler.environment.LocalFrame;
import org.onion_lang.onion.lang.kernel.type.*;
import org.onion_lang.onion.lang.syntax.Modifier;

/**
 * @author Kota Mizushima
 * Date: 2005/04/17
 */
public class ConstructorNode implements KernelNode, ConstructorSymbol {
  private int modifier;
  private ClassSymbol classType;
  private TypeSymbol[] arguments;
  private BlockNode block;
  private SuperInitNode superInitializer;
  private LocalFrame frame;
  
  public ConstructorNode(
    int modifier, ClassSymbol classType, 
    TypeSymbol[] arguments, BlockNode block, SuperInitNode superInitializer
  ) {
    this.modifier = modifier;
    this.classType = classType;
    this.arguments = arguments;
    this.block = block;
    this.superInitializer = superInitializer;
  }
  
  public static ConstructorNode newDefaultConstructor(ClassSymbol classType) {
    ReturnNode returnNode = new ReturnNode(null);
    BlockNode block = new BlockNode(
      new StatementNode[]{returnNode});
    SuperInitNode init = new SuperInitNode(
      classType.getSuperClass(), new TypeSymbol[0], new ExpressionNode[0]);
    ConstructorNode node =  new ConstructorNode(
      Modifier.PUBLIC, classType, new TypeSymbol[0], block, init);
    node.setFrame(new LocalFrame(null));
    return node;
  }
     
  public String getName() {
    return "new";
  }

  public TypeSymbol[] getArguments() {
    return arguments;
  }
  
  public ClassSymbol getClassType() {
    return classType;
  }
  
  public int getModifier() {
    return modifier;
  }
  
  public SuperInitNode getSuperInitializer() {
    return superInitializer;
  }
  
  public void setSuperInitializer(SuperInitNode superInitializer) {
    this.superInitializer = superInitializer;
  }
  
  public void setBlock(BlockNode block) {
    this.block = block;
  }
  
  public BlockNode getBlock() {
    return block;
  }

  public void setFrame(LocalFrame frame) {
    this.frame = frame;
  }
  
  public LocalFrame getFrame() {
    return frame;
  }
}
