/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.kernel;

/**
 * @author Kota Mizushima
 * Date: 2005/04/17
 */
public class IfNode implements StatementNode{
  private final ExpressionNode condition;
  private final StatementNode thenStatement, elseStatement;

  public IfNode(
    ExpressionNode condition, 
    StatementNode thenStatement, StatementNode elseStatement){
    this.condition = condition;
    this.thenStatement = thenStatement;
    this.elseStatement = elseStatement;
  }

  public ExpressionNode getCondition() {
    return condition;
  }

  public StatementNode getThenStatement() {
    return thenStatement;
  }

  public StatementNode getElseStatement() {
    return elseStatement;
  }
}
