/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.kernel;

import org.onion_lang.onion.lang.kernel.type.BasicSymbol;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

/**
 * @author Kota Mizushima
 * Date: 2005/04/17
 */
public class IsInstanceNode extends ExpressionNode {    
  public ExpressionNode target;
  public TypeSymbol checked;

  public IsInstanceNode(ExpressionNode target, TypeSymbol checked){
    this.target = target;
    this.checked = checked;
  }
  
  public TypeSymbol getCheckType() {
    return checked;
  }
  
  public ExpressionNode getTarget() {
    return target;
  }
  
  public TypeSymbol type() { return BasicSymbol.BOOLEAN; }
}