/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.kernel;

import org.onion_lang.onion.compiler.environment.ClosureLocalBinding;
import org.onion_lang.onion.lang.kernel.type.TypeSymbol;

/**
 * @author Kota Mizushima
 * Date: 2005/04/17
 */
public class LocalAssignmentNode extends ExpressionNode {
  private final int frame;
  private final int index;
  private final ExpressionNode value;
  private final TypeSymbol type;

  public LocalAssignmentNode(int frame, int index, TypeSymbol type, ExpressionNode value){
    this.frame = frame;
    this.index = index;
    this.value = value;
    this.type = type;
  }
  
  public LocalAssignmentNode(ClosureLocalBinding bind, ExpressionNode value){
    this.frame = bind.getFrame();
    this.index = bind.getIndex();
    this.type = bind.getType();
    this.value = value;
  }

  public int getFrame() {
    return frame;
  }

  public int getIndex() {
    return index;
  }

  public ExpressionNode getValue() {
    return value;
  }

  public TypeSymbol type() { return type; }
}
