/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.kernel.type;

import org.onion_lang.onion.lang.kernel.ExpressionNode;
import org.onion_lang.onion.lang.kernel.type.*;

/**
 * @author Kota Mizushima
 * Date: 2005/07/15
 */
public abstract class AbstractClassSymbol extends AbstractObjectSymbol implements ClassSymbol {
  private ConstructorFinder constructorFinder;
  
  public AbstractClassSymbol() {
    constructorFinder = new ConstructorFinder();
  }
  
  public ConstructorSymbol[] findConstructor(ExpressionNode[] params){
    return constructorFinder.find(this, params);
  }
  
  public boolean isClassType() {
    return true;
  }

  public boolean isArrayType() {
    return false;
  }
}
