/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.kernel.type;

import org.onion_lang.onion.lang.kernel.ExpressionNode;
import org.onion_lang.onion.lang.kernel.type.*;

/**
 * @author Kota Mizushima
 * Date: 2005/07/15
 */
public abstract class AbstractObjectSymbol implements ObjectSymbol {
  private MethodFinder methodFinder;
  private FieldFinder fieldFinder;
  
  public AbstractObjectSymbol() {
    methodFinder = new MethodFinder();
    fieldFinder = new FieldFinder();
  }

  public FieldSymbol findField(String name) {
    return fieldFinder.find(this, name);
  }

  public MethodSymbol[] findMethod(String name, ExpressionNode[] params) {
    return methodFinder.find(this, name, params);
  }

  public boolean isBasicType() {
    return false;
  }

  public boolean isNullType() {
    return false;
  }

  public boolean isObjectType() {
    return true;
  }
}
