/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
/*
 * Created on 2004/12/02
 */
package org.onion_lang.onion.lang.syntax;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;


import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;

;


/**
 * @author Kota Mizushima
 *  
 */
public class ClassDeclaration extends TypeDeclaration {
  
  private TypeSpecifier superClass;
  
  private TypeSpecifier[] interfaces;
  
  private AccessSection defaultSection;
  
  private List sections = new ArrayList();
  
  public ClassDeclaration(String name, TypeSpecifier superClass, TypeSpecifier[] interfaces, AccessSection defaultSection, AccessSection[] sections) {
    super(name);
    this.superClass = superClass;
    this.interfaces = (TypeSpecifier[]) interfaces.clone();
    this.defaultSection = defaultSection;
    this.sections.addAll(Arrays.asList(sections));
    setChild(superClass);
    setChildren(interfaces);
    setChild(defaultSection);
    setChildren(sections);
  }

  public Object accept(ASTVisitor visitor, Object context) {
    return visitor.visit(this, context);
  }

  public TypeSpecifier getSuperClass() {
    return superClass;
  }
  
  public TypeSpecifier[] getInterfaces(){
    return (TypeSpecifier[])interfaces.clone();
  }
  
  public AccessSection getDefaultSection(){
    return defaultSection;
  }
  
  public AccessSection[] getSections(){
    return (AccessSection[])sections.toArray(new AccessSection[0]);
  }
  
  public void addSection(AccessSection section){
    sections.add(section);
    setChild(section);
  }
  
}