/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
package org.onion_lang.onion.lang.syntax;

import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;

;

/**
 * N[W\A\؂̃m[h
 * @author Kota Mizushima
 * Date: 2005/04/10
 */
public class ClosureExpression extends Expression{
  private TypeSpecifier type;  
  private String name;  
  private ArgumentDeclaration[] arguments;  
  private TypeSpecifier returnType;
  private BlockStatement block;
  
  public ClosureExpression(
    TypeSpecifier type, String name, ArgumentDeclaration[] arguments, 
    TypeSpecifier returnType, BlockStatement block){
    this.type = type;
    this.name = name;
    this.arguments = arguments;
    this.returnType = returnType;
    this.block = block;
  }

  public Object accept(ASTVisitor visitor, Object context) {
    return visitor.visit(this, context);
  }
    
  public TypeSpecifier getType(){
    return type;
  }
  
  public void setType(TypeSpecifier type) {
    this.type = type;
  }

  public String getName() {
    return name;
  }
  
  public void setName(String name) {
    this.name = name;
  }
  
  public ArgumentDeclaration[] getArguments() {
    return (ArgumentDeclaration[])arguments.clone();
  }
  
  public void setArguments(ArgumentDeclaration[] arguments) {
    this.arguments = (ArgumentDeclaration[])arguments.clone();
  }
  
  public TypeSpecifier getReturnType() {
    return returnType;
  }
  
  public void setReturnType(TypeSpecifier returnType) {
    this.returnType = returnType;
  }
  
  public void setBlock(BlockStatement block){
    this.block = block;
  }
  
  public BlockStatement getBlock(){
    return block;
  }
}
