/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
/*
 * Created on 2004/12/02
 */
package org.onion_lang.onion.lang.syntax;


import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;


/**
 * @author Kota Mizushima
 * 
 */
public class GlobalVariableDeclaration extends TopLevelElement {
  
  private int modifier;
  
  private String name;
  
  private Expression initializer;
  
  private TypeSpecifier type;

  public GlobalVariableDeclaration(String name, TypeSpecifier type, Expression initializer) {
    this.name = name;
    this.initializer = initializer;
    this.type = type;
    setChild(initializer);
    setChild(type);
  }
  
  public void setModifier(int modifier){
    this.modifier = modifier;
  }
  
  public int getModifier(){
    return modifier;
  }
  
  public void setName(String name){
    this.name = name;
  }
  
  public String getName(){
    return name;
  }

  public Object accept(ASTVisitor visitor, Object context) {
    return visitor.visit(this, context);
  }
  
  public TypeSpecifier getType() {
    return type;
  }
  
  public void setType(TypeSpecifier type){
    this.type = type;
  }

  public Expression getInitializer() {
    return initializer;
  }
  
}