/* ************************************************************** *
 *                                                                *
 * Copyright (c) 2005, Kota Mizushima, All rights reserved.       *
 *                                                                *
 *                                                                *
 * This software is distributed under the modified BSD License.   *
 * ************************************************************** */
/*
 * Created on 2004/12/02
 */
package org.onion_lang.onion.lang.syntax;


import org.onion_lang.onion.lang.syntax.visitor.ASTVisitor;

;


/**
 * @author Kota Mizushima
 *  
 */
public class IfStatement extends Statement {
  public final Expression condition;

  public final BlockStatement thenBlock;

  public final BlockStatement elseBlock;

  /**
   * @param parent
   */
  public IfStatement(Expression condition, BlockStatement thenBlock, BlockStatement elseBlock) {
    this.condition = condition;
    this.thenBlock = thenBlock;
    this.elseBlock = elseBlock;
    setChild(condition);
    setChild(thenBlock);
    setChild(elseBlock);
  }

  public Object accept(ASTVisitor visitor, Object context) {
    return visitor.visit(this, context);
  }
}